/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.cost.StatsCalculator;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.security.GroupProvider;
import io.trino.sql.ParameterUtils;
import io.trino.sql.SqlFormatterUtil;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.Statement;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class CreateViewTask
implements DataDefinitionTask<CreateView> {
    private final SqlParser sqlParser;
    private final GroupProvider groupProvider;
    private final StatsCalculator statsCalculator;

    @Inject
    public CreateViewTask(SqlParser sqlParser, GroupProvider groupProvider, StatsCalculator statsCalculator) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.groupProvider = Objects.requireNonNull(groupProvider, "groupProvider is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
    }

    @Override
    public String getName() {
        return "CREATE VIEW";
    }

    @Override
    public String explain(CreateView statement, List<Expression> parameters) {
        return "CREATE VIEW " + statement.getName();
    }

    @Override
    public ListenableFuture<?> execute(CreateView statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        QualifiedObjectName name = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        accessControl.checkCanCreateView(session.toSecurityContext(), name);
        String sql = SqlFormatterUtil.getFormattedSql((Statement)statement.getQuery(), this.sqlParser);
        Analysis analysis = new Analyzer(session, metadata, this.sqlParser, this.groupProvider, accessControl, Optional.empty(), parameters, ParameterUtils.parameterExtractor((Statement)statement, parameters), stateMachine.getWarningCollector(), this.statsCalculator).analyze((Statement)statement);
        List columns = (List)analysis.getOutputDescriptor((Node)statement.getQuery()).getVisibleFields().stream().map(field -> new ConnectorViewDefinition.ViewColumn(field.getName().get(), field.getType().getTypeId())).collect(ImmutableList.toImmutableList());
        Optional<String> owner = Optional.of(session.getUser());
        if (statement.getSecurity().orElse(null) == CreateView.Security.INVOKER) {
            owner = Optional.empty();
        }
        ConnectorViewDefinition definition = new ConnectorViewDefinition(sql, session.getCatalog(), session.getSchema(), columns, statement.getComment(), owner, owner.isEmpty());
        metadata.createView(session, name, definition, statement.isReplace());
        return Futures.immediateFuture(null);
    }
}

