/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.DropSchema;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Optional;

public class DropSchemaTask
implements DataDefinitionTask<DropSchema> {
    @Override
    public String getName() {
        return "DROP SCHEMA";
    }

    @Override
    public String explain(DropSchema statement, List<Expression> parameters) {
        return "DROP SCHEMA " + statement.getSchemaName();
    }

    @Override
    public ListenableFuture<?> execute(DropSchema statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        CatalogSchemaName schema;
        if (statement.isCascade()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CASCADE is not yet supported for DROP SCHEMA");
        }
        Session session = stateMachine.getSession();
        if (!metadata.schemaExists(session, schema = MetadataUtil.createCatalogSchemaName(session, (Node)statement, Optional.of(statement.getSchemaName())))) {
            if (!statement.isExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, (Node)statement, "Schema '%s' does not exist", schema);
            }
            return Futures.immediateFuture(null);
        }
        accessControl.checkCanDropSchema(session.toSecurityContext(), schema);
        metadata.dropSchema(session, schema);
        return Futures.immediateFuture(null);
    }
}

