/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnHandle;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.RenameColumn;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class RenameColumnTask
implements DataDefinitionTask<RenameColumn> {
    @Override
    public String getName() {
        return "RENAME COLUMN";
    }

    @Override
    public ListenableFuture<?> execute(RenameColumn statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        QualifiedObjectName tableName;
        Session session = stateMachine.getSession();
        Optional<TableHandle> tableHandleOptional = metadata.getTableHandle(session, tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTable()));
        if (tableHandleOptional.isEmpty()) {
            if (!statement.isTableExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", tableName);
            }
            return Futures.immediateFuture(null);
        }
        TableHandle tableHandle = tableHandleOptional.get();
        String source = statement.getSource().getValue().toLowerCase(Locale.ENGLISH);
        String target = statement.getTarget().getValue().toLowerCase(Locale.ENGLISH);
        accessControl.checkCanRenameColumn(session.toSecurityContext(), tableName);
        Map<String, ColumnHandle> columnHandles = metadata.getColumnHandles(session, tableHandle);
        ColumnHandle columnHandle = columnHandles.get(source);
        if (columnHandle == null) {
            if (!statement.isColumnExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Column '%s' does not exist", source);
            }
            return Futures.immediateFuture(null);
        }
        if (columnHandles.containsKey(target)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_ALREADY_EXISTS, (Node)statement, "Column '%s' already exists", target);
        }
        if (metadata.getColumnMetadata(session, tableHandle, columnHandle).isHidden()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot rename hidden column", new Object[0]);
        }
        metadata.renameColumn(session, tableHandle, columnHandle, target);
        return Futures.immediateFuture(null);
    }
}

