/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.security.AccessControl;
import io.trino.security.SecurityContext;
import io.trino.spi.security.SelectedRole;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SetRole;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Locale;

public class SetRoleTask
implements DataDefinitionTask<SetRole> {
    @Override
    public String getName() {
        return "SET ROLE";
    }

    @Override
    public ListenableFuture<?> execute(SetRole statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        SelectedRole.Type type;
        Session session = stateMachine.getSession();
        String catalog = MetadataUtil.getSessionCatalog(metadata, session, (Node)statement);
        if (statement.getType() == SetRole.Type.ROLE) {
            accessControl.checkCanSetRole(SecurityContext.of(session), statement.getRole().map(c -> c.getValue().toLowerCase(Locale.ENGLISH)).get(), catalog);
        }
        switch (statement.getType()) {
            case ROLE: {
                type = SelectedRole.Type.ROLE;
                break;
            }
            case ALL: {
                type = SelectedRole.Type.ALL;
                break;
            }
            case NONE: {
                type = SelectedRole.Type.NONE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + statement.getType());
            }
        }
        stateMachine.addSetRole(catalog, new SelectedRole(type, statement.getRole().map(c -> c.getValue().toLowerCase(Locale.ENGLISH))));
        return Futures.immediateFuture(null);
    }
}

