/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SetViewAuthorization;
import io.trino.transaction.TransactionManager;
import java.util.List;

public class SetViewAuthorizationTask
implements DataDefinitionTask<SetViewAuthorization> {
    @Override
    public String getName() {
        return "SET VIEW AUTHORIZATION";
    }

    @Override
    public ListenableFuture<?> execute(SetViewAuthorization statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getSource());
        CatalogName catalogName = metadata.getCatalogHandle(session, viewName.getCatalogName()).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + viewName.getCatalogName()));
        metadata.getView(session, viewName).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "View '%s' does not exist", viewName));
        TrinoPrincipal principal = MetadataUtil.createPrincipal(statement.getPrincipal());
        if (principal.getType() == PrincipalType.ROLE && !metadata.listRoles(session, catalogName.getCatalogName()).contains(principal.getName())) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.ROLE_NOT_FOUND, (Node)statement, "Role '%s' does not exist", principal.getName());
        }
        accessControl.checkCanSetViewAuthorization(session.toSecurityContext(), viewName, principal);
        metadata.setViewAuthorization(session, viewName.asCatalogSchemaTableName(), principal);
        return Futures.immediateFuture(null);
    }
}

