/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.execution.buffer.OutputBufferMemoryManager;
import io.trino.execution.buffer.SerializedPage;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class SerializedPageReference {
    private static final AtomicIntegerFieldUpdater<SerializedPageReference> REFERENCE_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SerializedPageReference.class, "referenceCount");
    private final SerializedPage serializedPage;
    private volatile int referenceCount;

    public SerializedPageReference(SerializedPage serializedPage, int referenceCount) {
        this.serializedPage = Objects.requireNonNull(serializedPage, "page is null");
        Preconditions.checkArgument((referenceCount > 0 ? 1 : 0) != 0, (Object)"referenceCount must be at least 1");
        this.referenceCount = referenceCount;
    }

    public void addReference() {
        int oldReferences = REFERENCE_COUNT_UPDATER.getAndIncrement(this);
        Preconditions.checkState((oldReferences > 0 ? 1 : 0) != 0, (Object)"Page has already been dereferenced");
    }

    public SerializedPage getSerializedPage() {
        return this.serializedPage;
    }

    public int getPositionCount() {
        return this.serializedPage.getPositionCount();
    }

    public long getRetainedSizeInBytes() {
        return this.serializedPage.getRetainedSizeInBytes();
    }

    private boolean dereferencePage() {
        int remainingReferences = REFERENCE_COUNT_UPDATER.decrementAndGet(this);
        Preconditions.checkState((remainingReferences >= 0 ? 1 : 0) != 0, (Object)"Page reference count is negative");
        return remainingReferences == 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("referenceCount", this.referenceCount).toString();
    }

    public static void dereferencePages(List<SerializedPageReference> serializedPageReferences, PagesReleasedListener onPagesReleased) {
        Objects.requireNonNull(serializedPageReferences, "serializedPageReferences is null");
        Objects.requireNonNull(onPagesReleased, "onPagesReleased is null");
        int releasedPageCount = 0;
        long releasedMemorySizeInBytes = 0L;
        for (SerializedPageReference serializedPageReference : serializedPageReferences) {
            if (!serializedPageReference.dereferencePage()) continue;
            ++releasedPageCount;
            releasedMemorySizeInBytes += serializedPageReference.getRetainedSizeInBytes();
        }
        if (releasedPageCount > 0) {
            onPagesReleased.onPagesReleased(releasedPageCount, releasedMemorySizeInBytes);
        }
    }

    static interface PagesReleasedListener {
        public void onPagesReleased(int var1, long var2);

        public static PagesReleasedListener forOutputBufferMemoryManager(OutputBufferMemoryManager memoryManager) {
            return (releasedPagesCount, releasedMemorySizeInBytes) -> memoryManager.updateMemoryUsage(-releasedMemorySizeInBytes);
        }
    }
}

