/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.RemoteTask;
import io.trino.execution.scheduler.NodeMap;
import io.trino.metadata.InternalNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class NodeAssignmentStats {
    private final NodeTaskMap nodeTaskMap;
    private final Map<InternalNode, Integer> assignmentCount = new HashMap<InternalNode, Integer>();
    private final Map<InternalNode, Integer> splitCountByNode = new HashMap<InternalNode, Integer>();
    private final Map<String, Integer> queuedSplitCountByNode = new HashMap<String, Integer>();

    public NodeAssignmentStats(NodeTaskMap nodeTaskMap, NodeMap nodeMap, List<RemoteTask> existingTasks) {
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        for (InternalNode node : nodeMap.getNodesByHostAndPort().values()) {
            this.assignmentCount.put(node, 0);
        }
        for (RemoteTask task : existingTasks) {
            Preconditions.checkArgument((this.queuedSplitCountByNode.put(task.getNodeId(), task.getQueuedPartitionedSplitCount()) == null ? 1 : 0) != 0, (Object)"A single stage may not have multiple tasks running on the same node");
        }
    }

    public int getTotalSplitCount(InternalNode node) {
        return this.assignmentCount.getOrDefault(node, 0) + this.splitCountByNode.computeIfAbsent(node, this.nodeTaskMap::getPartitionedSplitsOnNode);
    }

    public int getQueuedSplitCountForStage(InternalNode node) {
        return this.queuedSplitCountByNode.getOrDefault(node.getNodeIdentifier(), 0) + this.assignmentCount.getOrDefault(node, 0);
    }

    public void addAssignedSplit(InternalNode node) {
        this.assignmentCount.merge(node, 1, Integer::sum);
    }

    public void removeAssignedSplit(InternalNode node) {
        this.assignmentCount.merge(node, 1, (x, y) -> x - y);
    }
}

