/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.log.Logger;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.RemoteTask;
import io.trino.execution.resourcegroups.IndexedPriorityQueue;
import io.trino.execution.scheduler.BucketNodeMap;
import io.trino.execution.scheduler.NodeAssignmentStats;
import io.trino.execution.scheduler.NodeMap;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.NodeSelector;
import io.trino.execution.scheduler.ResettableRandomizedIterator;
import io.trino.execution.scheduler.SplitPlacementResult;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.Split;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.HostAddress;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class UniformNodeSelector
implements NodeSelector {
    private static final Logger log = Logger.get(UniformNodeSelector.class);
    private final InternalNodeManager nodeManager;
    private final NodeTaskMap nodeTaskMap;
    private final boolean includeCoordinator;
    private final AtomicReference<Supplier<NodeMap>> nodeMap;
    private final int minCandidates;
    private final int maxSplitsPerNode;
    private final int maxPendingSplitsPerTask;
    private final boolean optimizedLocalScheduling;

    public UniformNodeSelector(InternalNodeManager nodeManager, NodeTaskMap nodeTaskMap, boolean includeCoordinator, Supplier<NodeMap> nodeMap, int minCandidates, int maxSplitsPerNode, int maxPendingSplitsPerTask, boolean optimizedLocalScheduling) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        this.includeCoordinator = includeCoordinator;
        this.nodeMap = new AtomicReference<Supplier<NodeMap>>(nodeMap);
        this.minCandidates = minCandidates;
        this.maxSplitsPerNode = maxSplitsPerNode;
        this.maxPendingSplitsPerTask = maxPendingSplitsPerTask;
        this.optimizedLocalScheduling = optimizedLocalScheduling;
    }

    @Override
    public void lockDownNodes() {
        this.nodeMap.set((Supplier<NodeMap>)Suppliers.ofInstance((Object)this.nodeMap.get().get()));
    }

    @Override
    public List<InternalNode> allNodes() {
        return NodeScheduler.getAllNodes(this.nodeMap.get().get(), this.includeCoordinator);
    }

    @Override
    public InternalNode selectCurrentNode() {
        return this.nodeManager.getCurrentNode();
    }

    @Override
    public List<InternalNode> selectRandomNodes(int limit, Set<InternalNode> excludedNodes) {
        return NodeScheduler.selectNodes(limit, NodeScheduler.randomizedNodes(this.nodeMap.get().get(), this.includeCoordinator, excludedNodes));
    }

    @Override
    public SplitPlacementResult computeAssignments(Set<Split> splits, List<RemoteTask> existingTasks) {
        Optional<InternalNode> chosenNode;
        List<InternalNode> candidateNodes;
        HashMultimap assignment = HashMultimap.create();
        NodeMap nodeMap = this.nodeMap.get().get();
        NodeAssignmentStats assignmentStats = new NodeAssignmentStats(this.nodeTaskMap, nodeMap, existingTasks);
        ResettableRandomizedIterator<InternalNode> randomCandidates = NodeScheduler.randomizedNodes(nodeMap, this.includeCoordinator, (Set<InternalNode>)ImmutableSet.of());
        HashSet<InternalNode> blockedExactNodes = new HashSet<InternalNode>();
        boolean splitWaitingForAnyNode = false;
        boolean splitsToBeRedistributed = false;
        Set<Object> remainingSplits = new HashSet();
        if (this.optimizedLocalScheduling) {
            for (Split split : splits) {
                if (split.isRemotelyAccessible() && !split.getAddresses().isEmpty()) {
                    candidateNodes = NodeScheduler.selectExactNodes(nodeMap, split.getAddresses(), this.includeCoordinator);
                    chosenNode = candidateNodes.stream().filter(ownerNode -> assignmentStats.getTotalSplitCount((InternalNode)ownerNode) < this.maxSplitsPerNode).min(Comparator.comparingInt(assignmentStats::getTotalSplitCount));
                    if (chosenNode.isPresent()) {
                        assignment.put((Object)chosenNode.get(), (Object)split);
                        assignmentStats.addAssignedSplit(chosenNode.get());
                        splitsToBeRedistributed = true;
                        continue;
                    }
                }
                remainingSplits.add(split);
            }
        } else {
            remainingSplits = splits;
        }
        for (Split split : remainingSplits) {
            int totalSplitCount;
            randomCandidates.reset();
            candidateNodes = !split.isRemotelyAccessible() ? NodeScheduler.selectExactNodes(nodeMap, split.getAddresses(), this.includeCoordinator) : NodeScheduler.selectNodes(this.minCandidates, randomCandidates);
            if (candidateNodes.isEmpty()) {
                log.debug("No nodes available to schedule %s. Available nodes %s", new Object[]{split, nodeMap.getNodesByHost().keys()});
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query");
            }
            chosenNode = null;
            int min = Integer.MAX_VALUE;
            for (InternalNode node : candidateNodes) {
                totalSplitCount = assignmentStats.getTotalSplitCount(node);
                if (totalSplitCount >= min || totalSplitCount >= this.maxSplitsPerNode) continue;
                chosenNode = node;
                min = totalSplitCount;
            }
            if (chosenNode == null) {
                for (InternalNode node : candidateNodes) {
                    totalSplitCount = assignmentStats.getQueuedSplitCountForStage(node);
                    if (totalSplitCount >= min || totalSplitCount >= this.maxPendingSplitsPerTask) continue;
                    chosenNode = node;
                    min = totalSplitCount;
                }
            }
            if (chosenNode != null) {
                assignment.put(chosenNode, (Object)split);
                assignmentStats.addAssignedSplit((InternalNode)((Object)chosenNode));
                continue;
            }
            if (split.isRemotelyAccessible()) {
                splitWaitingForAnyNode = true;
                continue;
            }
            if (splitWaitingForAnyNode) continue;
            blockedExactNodes.addAll(candidateNodes);
        }
        ListenableFuture<?> blocked = splitWaitingForAnyNode ? NodeScheduler.toWhenHasSplitQueueSpaceFuture(existingTasks, NodeScheduler.calculateLowWatermark(this.maxPendingSplitsPerTask)) : NodeScheduler.toWhenHasSplitQueueSpaceFuture(blockedExactNodes, existingTasks, NodeScheduler.calculateLowWatermark(this.maxPendingSplitsPerTask));
        if (splitsToBeRedistributed) {
            this.equateDistribution((Multimap<InternalNode, Split>)assignment, assignmentStats, nodeMap, this.includeCoordinator);
        }
        return new SplitPlacementResult(blocked, (Multimap<InternalNode, Split>)assignment);
    }

    @Override
    public SplitPlacementResult computeAssignments(Set<Split> splits, List<RemoteTask> existingTasks, BucketNodeMap bucketNodeMap) {
        return NodeScheduler.selectDistributionNodes(this.nodeMap.get().get(), this.nodeTaskMap, this.maxSplitsPerNode, this.maxPendingSplitsPerTask, splits, existingTasks, bucketNodeMap);
    }

    private void equateDistribution(Multimap<InternalNode, Split> assignment, NodeAssignmentStats assignmentStats, NodeMap nodeMap, boolean includeCoordinator) {
        if (assignment.isEmpty()) {
            return;
        }
        Collection allNodes = (Collection)nodeMap.getNodesByHostAndPort().values().stream().filter(node -> includeCoordinator || !nodeMap.getCoordinatorNodeIds().contains(node.getNodeIdentifier())).collect(ImmutableList.toImmutableList());
        if (allNodes.size() < 2) {
            return;
        }
        IndexedPriorityQueue<InternalNode> maxNodes = new IndexedPriorityQueue<InternalNode>();
        for (Object node2 : assignment.keySet()) {
            maxNodes.addOrUpdate((InternalNode)node2, assignmentStats.getTotalSplitCount((InternalNode)node2));
        }
        IndexedPriorityQueue<InternalNode> minNodes = new IndexedPriorityQueue<InternalNode>();
        for (InternalNode node3 : allNodes) {
            minNodes.addOrUpdate(node3, Long.MAX_VALUE - (long)assignmentStats.getTotalSplitCount(node3));
        }
        while (!maxNodes.isEmpty()) {
            InternalNode maxNode = (InternalNode)maxNodes.poll();
            InternalNode minNode = (InternalNode)minNodes.poll();
            if (assignmentStats.getTotalSplitCount(maxNode) - assignmentStats.getTotalSplitCount(minNode) <= 5) {
                return;
            }
            UniformNodeSelector.redistributeSplit(assignment, maxNode, minNode, nodeMap.getNodesByHost());
            assignmentStats.removeAssignedSplit(maxNode);
            assignmentStats.addAssignedSplit(minNode);
            if (assignment.containsKey((Object)maxNode)) {
                maxNodes.addOrUpdate(maxNode, assignmentStats.getTotalSplitCount(maxNode));
            }
            maxNodes.addOrUpdate(minNode, assignmentStats.getTotalSplitCount(minNode));
            minNodes.addOrUpdate(minNode, Long.MAX_VALUE - (long)assignmentStats.getTotalSplitCount(minNode));
            minNodes.addOrUpdate(maxNode, Long.MAX_VALUE - (long)assignmentStats.getTotalSplitCount(maxNode));
        }
        return;
    }

    @VisibleForTesting
    public static void redistributeSplit(Multimap<InternalNode, Split> assignment, InternalNode fromNode, InternalNode toNode, SetMultimap<InetAddress, InternalNode> nodesByHost) {
        Iterator splitIterator = assignment.get((Object)fromNode).iterator();
        Split splitToBeRedistributed = null;
        while (splitIterator.hasNext()) {
            Split split = (Split)splitIterator.next();
            if (split.getAddresses().isEmpty() || UniformNodeSelector.isSplitLocal(split.getAddresses(), fromNode.getHostAndPort(), nodesByHost)) continue;
            splitToBeRedistributed = split;
            break;
        }
        if (splitToBeRedistributed == null) {
            splitIterator = assignment.get((Object)fromNode).iterator();
            splitToBeRedistributed = (Split)splitIterator.next();
        }
        splitIterator.remove();
        assignment.put((Object)toNode, splitToBeRedistributed);
    }

    private static boolean isSplitLocal(List<HostAddress> splitAddresses, HostAddress nodeAddress, SetMultimap<InetAddress, InternalNode> nodesByHost) {
        for (HostAddress address : splitAddresses) {
            InetAddress inetAddress;
            if (nodeAddress.equals((Object)address)) {
                return true;
            }
            try {
                inetAddress = address.toInetAddress();
            }
            catch (UnknownHostException e) {
                continue;
            }
            if (address.hasPort()) continue;
            Set localNodes = nodesByHost.get((Object)inetAddress);
            return localNodes.stream().anyMatch(node -> node.getHostAndPort().equals((Object)nodeAddress));
        }
        return false;
    }
}

