/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"deprecated.legacy-system-pool-enabled"})
public class NodeMemoryConfig {
    public static final long AVAILABLE_HEAP_MEMORY = Runtime.getRuntime().maxMemory();
    public static final String QUERY_MAX_MEMORY_PER_NODE_CONFIG = "query.max-memory-per-node";
    public static final String QUERY_MAX_TOTAL_MEMORY_PER_NODE_CONFIG = "query.max-total-memory-per-node";
    private boolean isReservedPoolDisabled = true;
    private DataSize maxQueryMemoryPerNode = DataSize.ofBytes((long)Math.round((double)AVAILABLE_HEAP_MEMORY * 0.1));
    private DataSize maxQueryTotalMemoryPerNode = DataSize.ofBytes((long)Math.round((double)AVAILABLE_HEAP_MEMORY * 0.3));
    private DataSize heapHeadroom = DataSize.ofBytes((long)Math.round((double)AVAILABLE_HEAP_MEMORY * 0.3));

    @NotNull
    public DataSize getMaxQueryMemoryPerNode() {
        return this.maxQueryMemoryPerNode;
    }

    @Config(value="query.max-memory-per-node")
    public NodeMemoryConfig setMaxQueryMemoryPerNode(DataSize maxQueryMemoryPerNode) {
        this.maxQueryMemoryPerNode = maxQueryMemoryPerNode;
        return this;
    }

    @Deprecated
    @LegacyConfig(value={"experimental.reserved-pool-enabled"}, replacedBy="experimental.reserved-pool-disabled")
    public void setReservedPoolEnabled(boolean reservedPoolEnabled) {
        this.isReservedPoolDisabled = !reservedPoolEnabled;
    }

    @Deprecated
    public boolean isReservedPoolDisabled() {
        return this.isReservedPoolDisabled;
    }

    @Deprecated
    @Config(value="experimental.reserved-pool-disabled")
    public NodeMemoryConfig setReservedPoolDisabled(boolean reservedPoolDisabled) {
        this.isReservedPoolDisabled = reservedPoolDisabled;
        return this;
    }

    @NotNull
    public DataSize getMaxQueryTotalMemoryPerNode() {
        return this.maxQueryTotalMemoryPerNode;
    }

    @Config(value="query.max-total-memory-per-node")
    public NodeMemoryConfig setMaxQueryTotalMemoryPerNode(DataSize maxQueryTotalMemoryPerNode) {
        this.maxQueryTotalMemoryPerNode = maxQueryTotalMemoryPerNode;
        return this;
    }

    @NotNull
    public DataSize getHeapHeadroom() {
        return this.heapHeadroom;
    }

    @Config(value="memory.heap-headroom-per-node")
    @ConfigDescription(value="The amount of heap memory to set aside as headroom/buffer (e.g., for untracked allocations)")
    public NodeMemoryConfig setHeapHeadroom(DataSize heapHeadroom) {
        this.heapHeadroom = heapHeadroom;
        return this;
    }
}

