/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.metadata.FunctionId;
import io.trino.metadata.FunctionInvoker;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionListBuilder;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.LiteralFunction;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.SqlFunction;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.aggregation.ApproximateCountDistinctAggregation;
import io.trino.operator.aggregation.ApproximateDoublePercentileAggregations;
import io.trino.operator.aggregation.ApproximateDoublePercentileArrayAggregations;
import io.trino.operator.aggregation.ApproximateLongPercentileAggregations;
import io.trino.operator.aggregation.ApproximateLongPercentileArrayAggregations;
import io.trino.operator.aggregation.ApproximateRealPercentileAggregations;
import io.trino.operator.aggregation.ApproximateRealPercentileArrayAggregations;
import io.trino.operator.aggregation.ApproximateSetAggregation;
import io.trino.operator.aggregation.ArbitraryAggregationFunction;
import io.trino.operator.aggregation.AverageAggregations;
import io.trino.operator.aggregation.BigintApproximateMostFrequent;
import io.trino.operator.aggregation.BitwiseAndAggregation;
import io.trino.operator.aggregation.BitwiseOrAggregation;
import io.trino.operator.aggregation.BooleanAndAggregation;
import io.trino.operator.aggregation.BooleanOrAggregation;
import io.trino.operator.aggregation.CentralMomentsAggregation;
import io.trino.operator.aggregation.ChecksumAggregationFunction;
import io.trino.operator.aggregation.CountAggregation;
import io.trino.operator.aggregation.CountColumn;
import io.trino.operator.aggregation.CountIfAggregation;
import io.trino.operator.aggregation.DecimalAverageAggregation;
import io.trino.operator.aggregation.DecimalSumAggregation;
import io.trino.operator.aggregation.DefaultApproximateCountDistinctAggregation;
import io.trino.operator.aggregation.DoubleCorrelationAggregation;
import io.trino.operator.aggregation.DoubleCovarianceAggregation;
import io.trino.operator.aggregation.DoubleHistogramAggregation;
import io.trino.operator.aggregation.DoubleRegressionAggregation;
import io.trino.operator.aggregation.DoubleSumAggregation;
import io.trino.operator.aggregation.GeometricMeanAggregations;
import io.trino.operator.aggregation.InternalAggregationFunction;
import io.trino.operator.aggregation.IntervalDayToSecondAverageAggregation;
import io.trino.operator.aggregation.IntervalDayToSecondSumAggregation;
import io.trino.operator.aggregation.IntervalYearToMonthAverageAggregation;
import io.trino.operator.aggregation.IntervalYearToMonthSumAggregation;
import io.trino.operator.aggregation.LongSumAggregation;
import io.trino.operator.aggregation.MapAggregationFunction;
import io.trino.operator.aggregation.MapUnionAggregation;
import io.trino.operator.aggregation.MaxAggregationFunction;
import io.trino.operator.aggregation.MaxDataSizeForStats;
import io.trino.operator.aggregation.MaxNAggregationFunction;
import io.trino.operator.aggregation.MergeHyperLogLogAggregation;
import io.trino.operator.aggregation.MergeQuantileDigestFunction;
import io.trino.operator.aggregation.MergeTDigestAggregation;
import io.trino.operator.aggregation.MinAggregationFunction;
import io.trino.operator.aggregation.MinNAggregationFunction;
import io.trino.operator.aggregation.QuantileDigestAggregationFunction;
import io.trino.operator.aggregation.RealAverageAggregation;
import io.trino.operator.aggregation.RealCorrelationAggregation;
import io.trino.operator.aggregation.RealCovarianceAggregation;
import io.trino.operator.aggregation.RealGeometricMeanAggregations;
import io.trino.operator.aggregation.RealHistogramAggregation;
import io.trino.operator.aggregation.RealRegressionAggregation;
import io.trino.operator.aggregation.RealSumAggregation;
import io.trino.operator.aggregation.ReduceAggregationFunction;
import io.trino.operator.aggregation.SumDataSizeForStats;
import io.trino.operator.aggregation.TDigestAggregationFunction;
import io.trino.operator.aggregation.VarcharApproximateMostFrequent;
import io.trino.operator.aggregation.VarianceAggregation;
import io.trino.operator.aggregation.arrayagg.ArrayAggregationFunction;
import io.trino.operator.aggregation.histogram.Histogram;
import io.trino.operator.aggregation.minmaxby.MaxByAggregationFunction;
import io.trino.operator.aggregation.minmaxby.MaxByNAggregationFunction;
import io.trino.operator.aggregation.minmaxby.MinByAggregationFunction;
import io.trino.operator.aggregation.minmaxby.MinByNAggregationFunction;
import io.trino.operator.aggregation.multimapagg.MultimapAggregationFunction;
import io.trino.operator.scalar.ArrayAllMatchFunction;
import io.trino.operator.scalar.ArrayAnyMatchFunction;
import io.trino.operator.scalar.ArrayCardinalityFunction;
import io.trino.operator.scalar.ArrayCombinationsFunction;
import io.trino.operator.scalar.ArrayConcatFunction;
import io.trino.operator.scalar.ArrayConstructor;
import io.trino.operator.scalar.ArrayContains;
import io.trino.operator.scalar.ArrayContainsSequence;
import io.trino.operator.scalar.ArrayDistinctFunction;
import io.trino.operator.scalar.ArrayElementAtFunction;
import io.trino.operator.scalar.ArrayExceptFunction;
import io.trino.operator.scalar.ArrayFilterFunction;
import io.trino.operator.scalar.ArrayFlattenFunction;
import io.trino.operator.scalar.ArrayFunctions;
import io.trino.operator.scalar.ArrayIntersectFunction;
import io.trino.operator.scalar.ArrayJoin;
import io.trino.operator.scalar.ArrayMaxFunction;
import io.trino.operator.scalar.ArrayMinFunction;
import io.trino.operator.scalar.ArrayNgramsFunction;
import io.trino.operator.scalar.ArrayNoneMatchFunction;
import io.trino.operator.scalar.ArrayPositionFunction;
import io.trino.operator.scalar.ArrayReduceFunction;
import io.trino.operator.scalar.ArrayRemoveFunction;
import io.trino.operator.scalar.ArrayReverseFunction;
import io.trino.operator.scalar.ArrayShuffleFunction;
import io.trino.operator.scalar.ArraySliceFunction;
import io.trino.operator.scalar.ArraySortComparatorFunction;
import io.trino.operator.scalar.ArraySortFunction;
import io.trino.operator.scalar.ArraySubscriptOperator;
import io.trino.operator.scalar.ArrayToArrayCast;
import io.trino.operator.scalar.ArrayToElementConcatFunction;
import io.trino.operator.scalar.ArrayToJsonCast;
import io.trino.operator.scalar.ArrayTransformFunction;
import io.trino.operator.scalar.ArrayUnionFunction;
import io.trino.operator.scalar.ArraysOverlapFunction;
import io.trino.operator.scalar.BitwiseFunctions;
import io.trino.operator.scalar.CastFromUnknownOperator;
import io.trino.operator.scalar.CharacterStringCasts;
import io.trino.operator.scalar.ColorFunctions;
import io.trino.operator.scalar.CombineHashFunction;
import io.trino.operator.scalar.ConcatFunction;
import io.trino.operator.scalar.ConcatWsFunction;
import io.trino.operator.scalar.DataSizeFunctions;
import io.trino.operator.scalar.DateTimeFunctions;
import io.trino.operator.scalar.ElementToArrayConcatFunction;
import io.trino.operator.scalar.EmptyMapConstructor;
import io.trino.operator.scalar.FailureFunction;
import io.trino.operator.scalar.FormatFunction;
import io.trino.operator.scalar.GenericComparisonOperator;
import io.trino.operator.scalar.GenericDistinctFromOperator;
import io.trino.operator.scalar.GenericEqualOperator;
import io.trino.operator.scalar.GenericHashCodeOperator;
import io.trino.operator.scalar.GenericIndeterminateOperator;
import io.trino.operator.scalar.GenericLessThanOperator;
import io.trino.operator.scalar.GenericLessThanOrEqualOperator;
import io.trino.operator.scalar.GenericXxHash64Operator;
import io.trino.operator.scalar.Greatest;
import io.trino.operator.scalar.HmacFunctions;
import io.trino.operator.scalar.HyperLogLogFunctions;
import io.trino.operator.scalar.IdentityCast;
import io.trino.operator.scalar.JoniRegexpCasts;
import io.trino.operator.scalar.JoniRegexpFunctions;
import io.trino.operator.scalar.JoniRegexpReplaceLambdaFunction;
import io.trino.operator.scalar.JsonFunctions;
import io.trino.operator.scalar.JsonOperators;
import io.trino.operator.scalar.JsonStringToArrayCast;
import io.trino.operator.scalar.JsonStringToMapCast;
import io.trino.operator.scalar.JsonStringToRowCast;
import io.trino.operator.scalar.JsonToArrayCast;
import io.trino.operator.scalar.JsonToMapCast;
import io.trino.operator.scalar.JsonToRowCast;
import io.trino.operator.scalar.Least;
import io.trino.operator.scalar.LuhnCheckFunction;
import io.trino.operator.scalar.MapCardinalityFunction;
import io.trino.operator.scalar.MapConcatFunction;
import io.trino.operator.scalar.MapConstructor;
import io.trino.operator.scalar.MapElementAtFunction;
import io.trino.operator.scalar.MapEntriesFunction;
import io.trino.operator.scalar.MapFilterFunction;
import io.trino.operator.scalar.MapFromEntriesFunction;
import io.trino.operator.scalar.MapKeys;
import io.trino.operator.scalar.MapSubscriptOperator;
import io.trino.operator.scalar.MapToJsonCast;
import io.trino.operator.scalar.MapToMapCast;
import io.trino.operator.scalar.MapTransformKeysFunction;
import io.trino.operator.scalar.MapTransformValuesFunction;
import io.trino.operator.scalar.MapValues;
import io.trino.operator.scalar.MapZipWithFunction;
import io.trino.operator.scalar.MathFunctions;
import io.trino.operator.scalar.MultimapFromEntriesFunction;
import io.trino.operator.scalar.QuantileDigestFunctions;
import io.trino.operator.scalar.Re2JCastToRegexpFunction;
import io.trino.operator.scalar.Re2JRegexpFunctions;
import io.trino.operator.scalar.Re2JRegexpReplaceLambdaFunction;
import io.trino.operator.scalar.RepeatFunction;
import io.trino.operator.scalar.RowToJsonCast;
import io.trino.operator.scalar.RowToRowCast;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.operator.scalar.SequenceFunction;
import io.trino.operator.scalar.SessionFunctions;
import io.trino.operator.scalar.SplitToMapFunction;
import io.trino.operator.scalar.SplitToMultimapFunction;
import io.trino.operator.scalar.StringFunctions;
import io.trino.operator.scalar.TDigestFunctions;
import io.trino.operator.scalar.TryCastFunction;
import io.trino.operator.scalar.TryFunction;
import io.trino.operator.scalar.TypeOfFunction;
import io.trino.operator.scalar.UrlFunctions;
import io.trino.operator.scalar.VarbinaryFunctions;
import io.trino.operator.scalar.VersionFunction;
import io.trino.operator.scalar.WilsonInterval;
import io.trino.operator.scalar.WordStemFunction;
import io.trino.operator.scalar.ZipFunction;
import io.trino.operator.scalar.ZipWithFunction;
import io.trino.operator.scalar.time.LocalTimeFunction;
import io.trino.operator.scalar.time.TimeFunctions;
import io.trino.operator.scalar.time.TimeOperators;
import io.trino.operator.scalar.time.TimeToTimeWithTimeZoneCast;
import io.trino.operator.scalar.time.TimeToTimestampCast;
import io.trino.operator.scalar.time.TimeToTimestampWithTimeZoneCast;
import io.trino.operator.scalar.timestamp.DateFormat;
import io.trino.operator.scalar.timestamp.DateToTimestampCast;
import io.trino.operator.scalar.timestamp.DateTrunc;
import io.trino.operator.scalar.timestamp.ExtractDayOfWeek;
import io.trino.operator.scalar.timestamp.ExtractDayOfYear;
import io.trino.operator.scalar.timestamp.ExtractHour;
import io.trino.operator.scalar.timestamp.ExtractQuarter;
import io.trino.operator.scalar.timestamp.ExtractYear;
import io.trino.operator.scalar.timestamp.FormatDateTime;
import io.trino.operator.scalar.timestamp.HumanReadableSeconds;
import io.trino.operator.scalar.timestamp.LocalTimestamp;
import io.trino.operator.scalar.timestamp.SequenceIntervalDayToSecond;
import io.trino.operator.scalar.timestamp.SequenceIntervalYearToMonth;
import io.trino.operator.scalar.timestamp.TimeWithTimeZoneToTimestampCast;
import io.trino.operator.scalar.timestamp.TimestampOperators;
import io.trino.operator.scalar.timestamp.TimestampToDateCast;
import io.trino.operator.scalar.timestamp.TimestampToJsonCast;
import io.trino.operator.scalar.timestamp.TimestampToTimeCast;
import io.trino.operator.scalar.timestamp.TimestampToTimeWithTimeZoneCast;
import io.trino.operator.scalar.timestamp.TimestampToTimestampCast;
import io.trino.operator.scalar.timestamp.TimestampToTimestampWithTimeZoneCast;
import io.trino.operator.scalar.timestamp.TimestampToVarcharCast;
import io.trino.operator.scalar.timestamp.ToIso8601;
import io.trino.operator.scalar.timestamp.ToUnixTime;
import io.trino.operator.scalar.timestamp.VarcharToTimestampCast;
import io.trino.operator.scalar.timestamp.WithTimeZone;
import io.trino.operator.scalar.timestamptz.AtTimeZone;
import io.trino.operator.scalar.timestamptz.AtTimeZoneWithOffset;
import io.trino.operator.scalar.timestamptz.CurrentTimestamp;
import io.trino.operator.scalar.timestamptz.DateDiff;
import io.trino.operator.scalar.timestamptz.DateToTimestampWithTimeZoneCast;
import io.trino.operator.scalar.timestamptz.ExtractDay;
import io.trino.operator.scalar.timestamptz.ExtractMonth;
import io.trino.operator.scalar.timestamptz.ExtractWeekOfYear;
import io.trino.operator.scalar.timestamptz.ExtractYearOfWeek;
import io.trino.operator.scalar.timestamptz.LastDayOfMonth;
import io.trino.operator.scalar.timestamptz.TimeZoneHour;
import io.trino.operator.scalar.timestamptz.TimeZoneMinute;
import io.trino.operator.scalar.timestamptz.TimestampWithTimeZoneOperators;
import io.trino.operator.scalar.timestamptz.TimestampWithTimeZoneToDateCast;
import io.trino.operator.scalar.timestamptz.TimestampWithTimeZoneToTimeCast;
import io.trino.operator.scalar.timestamptz.TimestampWithTimeZoneToTimeWithTimeZoneCast;
import io.trino.operator.scalar.timestamptz.TimestampWithTimeZoneToTimestampCast;
import io.trino.operator.scalar.timestamptz.TimestampWithTimeZoneToTimestampWithTimeZoneCast;
import io.trino.operator.scalar.timestamptz.TimestampWithTimeZoneToVarcharCast;
import io.trino.operator.scalar.timestamptz.VarcharToTimestampWithTimeZoneCast;
import io.trino.operator.scalar.timetz.CurrentTime;
import io.trino.operator.scalar.timetz.DateAdd;
import io.trino.operator.scalar.timetz.ExtractMillisecond;
import io.trino.operator.scalar.timetz.ExtractMinute;
import io.trino.operator.scalar.timetz.ExtractSecond;
import io.trino.operator.scalar.timetz.TimeWithTimeZoneOperators;
import io.trino.operator.scalar.timetz.TimeWithTimeZoneToTimeCast;
import io.trino.operator.scalar.timetz.TimeWithTimeZoneToTimeWithTimeZoneCast;
import io.trino.operator.scalar.timetz.TimeWithTimeZoneToTimestampWithTimeZoneCast;
import io.trino.operator.scalar.timetz.TimeWithTimeZoneToVarcharCast;
import io.trino.operator.scalar.timetz.VarcharToTimeWithTimeZoneCast;
import io.trino.operator.window.AggregateWindowFunction;
import io.trino.operator.window.CumulativeDistributionFunction;
import io.trino.operator.window.DenseRankFunction;
import io.trino.operator.window.FirstValueFunction;
import io.trino.operator.window.LagFunction;
import io.trino.operator.window.LastValueFunction;
import io.trino.operator.window.LeadFunction;
import io.trino.operator.window.NTileFunction;
import io.trino.operator.window.NthValueFunction;
import io.trino.operator.window.PercentRankFunction;
import io.trino.operator.window.RankFunction;
import io.trino.operator.window.RowNumberFunction;
import io.trino.operator.window.SqlWindowFunction;
import io.trino.operator.window.WindowFunctionSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.DynamicFilters;
import io.trino.sql.analyzer.FeaturesConfig;
import io.trino.sql.tree.QualifiedName;
import io.trino.type.BigintOperators;
import io.trino.type.BlockTypeOperators;
import io.trino.type.BooleanOperators;
import io.trino.type.DateOperators;
import io.trino.type.DateTimeOperators;
import io.trino.type.DecimalCasts;
import io.trino.type.DecimalOperators;
import io.trino.type.DecimalSaturatedFloorCasts;
import io.trino.type.DecimalToDecimalCasts;
import io.trino.type.DoubleOperators;
import io.trino.type.HyperLogLogOperators;
import io.trino.type.IntegerOperators;
import io.trino.type.IntervalDayTimeOperators;
import io.trino.type.IntervalYearMonthOperators;
import io.trino.type.IpAddressOperators;
import io.trino.type.LikeFunctions;
import io.trino.type.QuantileDigestOperators;
import io.trino.type.RealOperators;
import io.trino.type.SmallintOperators;
import io.trino.type.TDigestOperators;
import io.trino.type.TinyintOperators;
import io.trino.type.UuidOperators;
import io.trino.type.VarcharOperators;
import io.trino.type.setdigest.BuildSetDigestAggregation;
import io.trino.type.setdigest.MergeSetDigestAggregation;
import io.trino.type.setdigest.SetDigestFunctions;
import io.trino.type.setdigest.SetDigestOperators;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FunctionRegistry {
    private final Cache<FunctionBinding, ScalarFunctionImplementation> specializedScalarCache;
    private final Cache<FunctionBinding, InternalAggregationFunction> specializedAggregationCache;
    private final Cache<FunctionBinding, WindowFunctionSupplier> specializedWindowCache;
    private volatile FunctionMap functions = new FunctionMap();

    public FunctionRegistry(Supplier<BlockEncodingSerde> blockEncodingSerdeSupplier, FeaturesConfig featuresConfig, TypeOperators typeOperators, BlockTypeOperators blockTypeOperators, String nodeVersion) {
        this.specializedScalarCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build();
        this.specializedAggregationCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build();
        this.specializedWindowCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build();
        FunctionListBuilder builder = new FunctionListBuilder().window(RowNumberFunction.class).window(RankFunction.class).window(DenseRankFunction.class).window(PercentRankFunction.class).window(CumulativeDistributionFunction.class).window(NTileFunction.class).window(FirstValueFunction.class).window(LastValueFunction.class).window(NthValueFunction.class).window(LagFunction.class).window(LeadFunction.class).aggregate(ApproximateCountDistinctAggregation.class).aggregate(DefaultApproximateCountDistinctAggregation.class).aggregate(SumDataSizeForStats.class).aggregate(MaxDataSizeForStats.class).aggregates(CountAggregation.class).aggregates(VarianceAggregation.class).aggregates(CentralMomentsAggregation.class).aggregates(ApproximateLongPercentileAggregations.class).aggregates(ApproximateLongPercentileArrayAggregations.class).aggregates(ApproximateDoublePercentileAggregations.class).aggregates(ApproximateDoublePercentileArrayAggregations.class).aggregates(ApproximateRealPercentileAggregations.class).aggregates(ApproximateRealPercentileArrayAggregations.class).aggregates(CountIfAggregation.class).aggregates(BooleanAndAggregation.class).aggregates(BooleanOrAggregation.class).aggregates(DoubleSumAggregation.class).aggregates(RealSumAggregation.class).aggregates(LongSumAggregation.class).aggregates(IntervalDayToSecondSumAggregation.class).aggregates(IntervalYearToMonthSumAggregation.class).aggregates(AverageAggregations.class).function(RealAverageAggregation.REAL_AVERAGE_AGGREGATION).aggregates(IntervalDayToSecondAverageAggregation.class).aggregates(IntervalYearToMonthAverageAggregation.class).aggregates(GeometricMeanAggregations.class).aggregates(RealGeometricMeanAggregations.class).aggregates(MergeHyperLogLogAggregation.class).aggregates(ApproximateSetAggregation.class).aggregates(TDigestAggregationFunction.class).functions(QuantileDigestAggregationFunction.QDIGEST_AGG, QuantileDigestAggregationFunction.QDIGEST_AGG_WITH_WEIGHT, QuantileDigestAggregationFunction.QDIGEST_AGG_WITH_WEIGHT_AND_ERROR).function(MergeQuantileDigestFunction.MERGE).aggregates(MergeTDigestAggregation.class).aggregates(DoubleHistogramAggregation.class).aggregates(RealHistogramAggregation.class).aggregates(DoubleCovarianceAggregation.class).aggregates(RealCovarianceAggregation.class).aggregates(DoubleRegressionAggregation.class).aggregates(RealRegressionAggregation.class).aggregates(DoubleCorrelationAggregation.class).aggregates(RealCorrelationAggregation.class).aggregates(BitwiseOrAggregation.class).aggregates(BitwiseAndAggregation.class).scalar(RepeatFunction.class).scalars(SequenceFunction.class).scalars(SessionFunctions.class).scalars(StringFunctions.class).scalars(WordStemFunction.class).scalar(SplitToMapFunction.class).scalar(SplitToMultimapFunction.class).scalars(VarbinaryFunctions.class).scalars(UrlFunctions.class).scalars(MathFunctions.class).scalar(MathFunctions.Abs.class).scalar(MathFunctions.Sign.class).scalar(MathFunctions.Round.class).scalar(MathFunctions.RoundN.class).scalar(MathFunctions.Truncate.class).scalar(MathFunctions.TruncateN.class).scalar(MathFunctions.Ceiling.class).scalar(MathFunctions.Floor.class).scalars(BitwiseFunctions.class).scalars(DateTimeFunctions.class).scalar(DateTimeFunctions.FromUnixtimeNanosDecimal.class).scalars(JsonFunctions.class).scalars(ColorFunctions.class).scalars(HyperLogLogFunctions.class).scalars(QuantileDigestFunctions.class).scalars(TDigestFunctions.class).scalars(BooleanOperators.class).scalars(BigintOperators.class).scalars(IntegerOperators.class).scalars(SmallintOperators.class).scalars(TinyintOperators.class).scalars(DoubleOperators.class).scalars(RealOperators.class).scalars(VarcharOperators.class).scalars(DateOperators.class).scalars(IntervalDayTimeOperators.class).scalars(IntervalYearMonthOperators.class).scalars(DateTimeOperators.class).scalars(HyperLogLogOperators.class).scalars(QuantileDigestOperators.class).scalars(TDigestOperators.class).scalars(IpAddressOperators.class).scalars(UuidOperators.class).scalars(LikeFunctions.class).scalars(ArrayFunctions.class).scalars(HmacFunctions.class).scalars(DataSizeFunctions.class).scalar(ArrayCardinalityFunction.class).scalar(ArrayContains.class).scalar(ArrayContainsSequence.class).scalar(ArrayFilterFunction.class).scalar(ArrayPositionFunction.class).scalars(CombineHashFunction.class).scalars(JsonOperators.class).scalars(FailureFunction.class).scalars(JoniRegexpCasts.class).scalars(CharacterStringCasts.class).scalars(LuhnCheckFunction.class).scalar(DecimalOperators.Negation.class).functions(IdentityCast.IDENTITY_CAST, CastFromUnknownOperator.CAST_FROM_UNKNOWN).scalar(ArrayRemoveFunction.class).scalar(ArrayElementAtFunction.class).scalar(ArraySortFunction.class).scalar(ArraySortComparatorFunction.class).scalar(ArrayShuffleFunction.class).scalar(ArrayReverseFunction.class).scalar(ArrayMinFunction.class).scalar(ArrayMaxFunction.class).scalar(ArrayDistinctFunction.class).scalar(ArrayIntersectFunction.class).scalar(ArraysOverlapFunction.class).scalar(ArrayUnionFunction.class).scalar(ArrayExceptFunction.class).scalar(ArraySliceFunction.class).scalar(ArrayCombinationsFunction.class).scalar(ArrayNgramsFunction.class).scalar(ArrayAllMatchFunction.class).scalar(ArrayAnyMatchFunction.class).scalar(ArrayNoneMatchFunction.class).scalar(MapEntriesFunction.class).scalar(MapFromEntriesFunction.class).scalar(MultimapFromEntriesFunction.class).scalar(MapKeys.class).scalar(MapValues.class).scalar(MapCardinalityFunction.class).scalar(EmptyMapConstructor.class).scalar(TypeOfFunction.class).scalar(TryFunction.class).scalar(ConcatWsFunction.ConcatArrayWs.class).scalar(DynamicFilters.Function.class).functions(ZipWithFunction.ZIP_WITH_FUNCTION, MapZipWithFunction.MAP_ZIP_WITH_FUNCTION).functions(ZipFunction.ZIP_FUNCTIONS).functions(ArrayJoin.ARRAY_JOIN, ArrayJoin.ARRAY_JOIN_WITH_NULL_REPLACEMENT).functions(ArrayToArrayCast.ARRAY_TO_ARRAY_CAST).functions(ArrayToElementConcatFunction.ARRAY_TO_ELEMENT_CONCAT_FUNCTION, ElementToArrayConcatFunction.ELEMENT_TO_ARRAY_CONCAT_FUNCTION).function(MapElementAtFunction.MAP_ELEMENT_AT).function(new MapConcatFunction(blockTypeOperators)).function(new MapToMapCast(blockTypeOperators)).function(ArrayFlattenFunction.ARRAY_FLATTEN_FUNCTION).function(ArrayConcatFunction.ARRAY_CONCAT_FUNCTION).functions(ArrayConstructor.ARRAY_CONSTRUCTOR, ArraySubscriptOperator.ARRAY_SUBSCRIPT, ArrayToJsonCast.ARRAY_TO_JSON, JsonToArrayCast.JSON_TO_ARRAY, JsonStringToArrayCast.JSON_STRING_TO_ARRAY).function(ArrayAggregationFunction.ARRAY_AGG).functions(new MapSubscriptOperator()).functions(MapConstructor.MAP_CONSTRUCTOR, MapToJsonCast.MAP_TO_JSON, JsonToMapCast.JSON_TO_MAP, JsonStringToMapCast.JSON_STRING_TO_MAP).functions(new MapAggregationFunction(blockTypeOperators), new MapUnionAggregation(blockTypeOperators)).function(ReduceAggregationFunction.REDUCE_AGG).function(new MultimapAggregationFunction(blockTypeOperators)).functions(DecimalCasts.DECIMAL_TO_VARCHAR_CAST, DecimalCasts.DECIMAL_TO_INTEGER_CAST, DecimalCasts.DECIMAL_TO_BIGINT_CAST, DecimalCasts.DECIMAL_TO_DOUBLE_CAST, DecimalCasts.DECIMAL_TO_REAL_CAST, DecimalCasts.DECIMAL_TO_BOOLEAN_CAST, DecimalCasts.DECIMAL_TO_TINYINT_CAST, DecimalCasts.DECIMAL_TO_SMALLINT_CAST).functions(DecimalCasts.VARCHAR_TO_DECIMAL_CAST, DecimalCasts.INTEGER_TO_DECIMAL_CAST, DecimalCasts.BIGINT_TO_DECIMAL_CAST, DecimalCasts.DOUBLE_TO_DECIMAL_CAST, DecimalCasts.REAL_TO_DECIMAL_CAST, DecimalCasts.BOOLEAN_TO_DECIMAL_CAST, DecimalCasts.TINYINT_TO_DECIMAL_CAST, DecimalCasts.SMALLINT_TO_DECIMAL_CAST).functions(DecimalCasts.JSON_TO_DECIMAL_CAST, DecimalCasts.DECIMAL_TO_JSON_CAST).functions(DecimalOperators.DECIMAL_ADD_OPERATOR, DecimalOperators.DECIMAL_SUBTRACT_OPERATOR, DecimalOperators.DECIMAL_MULTIPLY_OPERATOR, DecimalOperators.DECIMAL_DIVIDE_OPERATOR, DecimalOperators.DECIMAL_MODULUS_OPERATOR).function(DecimalSaturatedFloorCasts.DECIMAL_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_BIGINT_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.BIGINT_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_INTEGER_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.INTEGER_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_SMALLINT_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.SMALLINT_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_TINYINT_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.TINYINT_TO_DECIMAL_SATURATED_FLOOR_CAST).function(new Histogram(blockTypeOperators)).function(new ChecksumAggregationFunction(blockTypeOperators)).function(ArbitraryAggregationFunction.ARBITRARY_AGGREGATION).functions(Greatest.GREATEST, Least.LEAST).functions(MaxByAggregationFunction.MAX_BY, MinByAggregationFunction.MIN_BY, new MaxByNAggregationFunction(blockTypeOperators), new MinByNAggregationFunction(blockTypeOperators)).functions(MaxAggregationFunction.MAX_AGGREGATION, MinAggregationFunction.MIN_AGGREGATION, new MaxNAggregationFunction(blockTypeOperators), new MinNAggregationFunction(blockTypeOperators)).function(CountColumn.COUNT_COLUMN).functions(RowToJsonCast.ROW_TO_JSON, JsonToRowCast.JSON_TO_ROW, JsonStringToRowCast.JSON_STRING_TO_ROW, RowToRowCast.ROW_TO_ROW_CAST).functions(ConcatFunction.VARCHAR_CONCAT, ConcatFunction.VARBINARY_CONCAT).function(ConcatWsFunction.CONCAT_WS).function(DecimalToDecimalCasts.DECIMAL_TO_DECIMAL_CAST).function(Re2JCastToRegexpFunction.castVarcharToRe2JRegexp(featuresConfig.getRe2JDfaStatesLimit(), featuresConfig.getRe2JDfaRetries())).function(Re2JCastToRegexpFunction.castCharToRe2JRegexp(featuresConfig.getRe2JDfaStatesLimit(), featuresConfig.getRe2JDfaRetries())).function(DecimalAverageAggregation.DECIMAL_AVERAGE_AGGREGATION).function(DecimalSumAggregation.DECIMAL_SUM_AGGREGATION).function(MathFunctions.DECIMAL_MOD_FUNCTION).functions(ArrayTransformFunction.ARRAY_TRANSFORM_FUNCTION, ArrayReduceFunction.ARRAY_REDUCE_FUNCTION).functions(MapFilterFunction.MAP_FILTER_FUNCTION, new MapTransformKeysFunction(blockTypeOperators), MapTransformValuesFunction.MAP_TRANSFORM_VALUES_FUNCTION).function(FormatFunction.FORMAT_FUNCTION).function(TryCastFunction.TRY_CAST).function(new LiteralFunction(blockEncodingSerdeSupplier)).function(new GenericEqualOperator(typeOperators)).function(new GenericHashCodeOperator(typeOperators)).function(new GenericXxHash64Operator(typeOperators)).function(new GenericDistinctFromOperator(typeOperators)).function(new GenericIndeterminateOperator(typeOperators)).function(new GenericComparisonOperator(typeOperators)).function(new GenericLessThanOperator(typeOperators)).function(new GenericLessThanOrEqualOperator(typeOperators)).function(new VersionFunction(nodeVersion)).aggregate(MergeSetDigestAggregation.class).aggregate(BuildSetDigestAggregation.class).scalars(SetDigestFunctions.class).scalars(SetDigestOperators.class).scalars(WilsonInterval.class).aggregate(BigintApproximateMostFrequent.class).aggregate(VarcharApproximateMostFrequent.class);
        builder.scalar(TimestampOperators.TimestampPlusIntervalDayToSecond.class).scalar(TimestampOperators.IntervalDayToSecondPlusTimestamp.class).scalar(TimestampOperators.TimestampPlusIntervalYearToMonth.class).scalar(TimestampOperators.IntervalYearToMonthPlusTimestamp.class).scalar(TimestampOperators.TimestampMinusIntervalDayToSecond.class).scalar(TimestampOperators.TimestampMinusIntervalYearToMonth.class).scalar(TimestampOperators.TimestampMinusTimestamp.class).scalar(TimestampToTimestampCast.class).scalar(TimestampToTimeCast.class).scalar(TimestampToTimeWithTimeZoneCast.class).scalar(TimestampToTimestampWithTimeZoneCast.class).scalar(TimestampToDateCast.class).scalar(TimestampToVarcharCast.class).scalar(TimestampToJsonCast.class).scalar(DateToTimestampCast.class).scalar(TimeToTimestampCast.class).scalar(TimeWithTimeZoneToTimestampCast.class).scalar(TimestampWithTimeZoneToTimestampCast.class).scalar(VarcharToTimestampCast.class).scalar(LocalTimestamp.class).scalar(DateTrunc.class).scalar(ToUnixTime.class).scalar(HumanReadableSeconds.class).scalar(ToIso8601.class).scalar(WithTimeZone.class).scalar(FormatDateTime.class).scalar(DateFormat.class).scalar(SequenceIntervalYearToMonth.class).scalar(SequenceIntervalDayToSecond.class).scalar(io.trino.operator.scalar.timestamp.DateAdd.class).scalar(io.trino.operator.scalar.timestamp.DateDiff.class).scalar(ExtractYear.class).scalar(ExtractQuarter.class).scalar(io.trino.operator.scalar.timestamp.ExtractMonth.class).scalar(io.trino.operator.scalar.timestamp.ExtractDay.class).scalar(ExtractHour.class).scalar(io.trino.operator.scalar.timestamp.ExtractMinute.class).scalar(io.trino.operator.scalar.timestamp.ExtractSecond.class).scalar(io.trino.operator.scalar.timestamp.ExtractMillisecond.class).scalar(ExtractDayOfYear.class).scalar(ExtractDayOfWeek.class).scalar(io.trino.operator.scalar.timestamp.ExtractWeekOfYear.class).scalar(io.trino.operator.scalar.timestamp.ExtractYearOfWeek.class).scalar(io.trino.operator.scalar.timestamp.LastDayOfMonth.class);
        builder.scalar(TimestampWithTimeZoneOperators.TimestampPlusIntervalDayToSecond.class).scalar(TimestampWithTimeZoneOperators.IntervalDayToSecondPlusTimestamp.class).scalar(TimestampWithTimeZoneOperators.TimestampMinusIntervalDayToSecond.class).scalar(TimestampWithTimeZoneOperators.TimestampPlusIntervalYearToMonth.class).scalar(TimestampWithTimeZoneOperators.IntervalYearToMonthPlusTimestamp.class).scalar(TimestampWithTimeZoneOperators.TimestampMinusIntervalYearToMonth.class).scalar(TimestampWithTimeZoneOperators.TimestampMinusTimestamp.class).scalar(CurrentTimestamp.class).scalar(io.trino.operator.scalar.timestamptz.ExtractYear.class).scalar(io.trino.operator.scalar.timestamptz.ExtractQuarter.class).scalar(ExtractMonth.class).scalar(ExtractDay.class).scalar(io.trino.operator.scalar.timestamptz.ExtractHour.class).scalar(io.trino.operator.scalar.timestamptz.ExtractMinute.class).scalar(io.trino.operator.scalar.timestamptz.ExtractSecond.class).scalar(io.trino.operator.scalar.timestamptz.ExtractMillisecond.class).scalar(io.trino.operator.scalar.timestamptz.ExtractDayOfYear.class).scalar(io.trino.operator.scalar.timestamptz.ExtractDayOfWeek.class).scalar(ExtractWeekOfYear.class).scalar(ExtractYearOfWeek.class).scalar(io.trino.operator.scalar.timestamptz.ToIso8601.class).scalar(io.trino.operator.scalar.timestamptz.DateAdd.class).scalar(io.trino.operator.scalar.timestamptz.DateTrunc.class).scalar(TimeZoneHour.class).scalar(TimeZoneMinute.class).scalar(DateDiff.class).scalar(io.trino.operator.scalar.timestamptz.DateFormat.class).scalar(io.trino.operator.scalar.timestamptz.FormatDateTime.class).scalar(io.trino.operator.scalar.timestamptz.ToUnixTime.class).scalar(LastDayOfMonth.class).scalar(AtTimeZone.class).scalar(AtTimeZoneWithOffset.class).scalar(DateToTimestampWithTimeZoneCast.class).scalar(TimestampWithTimeZoneToDateCast.class).scalar(TimestampWithTimeZoneToTimeCast.class).scalar(TimestampWithTimeZoneToTimestampWithTimeZoneCast.class).scalar(TimestampWithTimeZoneToTimeWithTimeZoneCast.class).scalar(TimestampWithTimeZoneToVarcharCast.class).scalar(TimeToTimestampWithTimeZoneCast.class).scalar(TimeWithTimeZoneToTimestampWithTimeZoneCast.class).scalar(VarcharToTimestampWithTimeZoneCast.class);
        builder.scalar(LocalTimeFunction.class).scalars(TimeOperators.class).scalars(TimeFunctions.class).scalar(TimeToTimeWithTimeZoneCast.class);
        builder.scalar(TimeWithTimeZoneOperators.TimePlusIntervalDayToSecond.class).scalar(TimeWithTimeZoneOperators.IntervalDayToSecondPlusTime.class).scalar(TimeWithTimeZoneOperators.TimeMinusIntervalDayToSecond.class).scalar(TimeWithTimeZoneOperators.TimeMinusTime.class).scalar(TimeWithTimeZoneToTimeCast.class).scalar(TimeWithTimeZoneToTimeWithTimeZoneCast.class).scalar(TimeWithTimeZoneToVarcharCast.class).scalar(VarcharToTimeWithTimeZoneCast.class).scalar(io.trino.operator.scalar.timetz.DateDiff.class).scalar(DateAdd.class).scalar(io.trino.operator.scalar.timetz.ExtractHour.class).scalar(ExtractMinute.class).scalar(ExtractSecond.class).scalar(ExtractMillisecond.class).scalar(io.trino.operator.scalar.timetz.TimeZoneHour.class).scalar(io.trino.operator.scalar.timetz.TimeZoneMinute.class).scalar(io.trino.operator.scalar.timetz.DateTrunc.class).scalar(io.trino.operator.scalar.timetz.AtTimeZone.class).scalar(io.trino.operator.scalar.timetz.AtTimeZoneWithOffset.class).scalar(CurrentTime.class);
        switch (featuresConfig.getRegexLibrary()) {
            case JONI: {
                builder.scalars(JoniRegexpFunctions.class);
                builder.scalar(JoniRegexpReplaceLambdaFunction.class);
                break;
            }
            case RE2J: {
                builder.scalars(Re2JRegexpFunctions.class);
                builder.scalar(Re2JRegexpReplaceLambdaFunction.class);
            }
        }
        this.addFunctions(builder.getFunctions());
    }

    public final synchronized void addFunctions(List<? extends SqlFunction> functions) {
        for (SqlFunction sqlFunction : functions) {
            FunctionMetadata functionMetadata;
            String name = sqlFunction.getFunctionMetadata().getSignature().getName();
            if (!(!Signature.isOperatorName(name) || sqlFunction instanceof GenericEqualOperator || sqlFunction instanceof GenericHashCodeOperator || sqlFunction instanceof GenericXxHash64Operator || sqlFunction instanceof GenericDistinctFromOperator || sqlFunction instanceof GenericIndeterminateOperator || sqlFunction instanceof GenericComparisonOperator || sqlFunction instanceof GenericLessThanOperator || sqlFunction instanceof GenericLessThanOrEqualOperator)) {
                OperatorType operatorType = Signature.unmangleOperator(name);
                Preconditions.checkArgument((operatorType != OperatorType.EQUAL && operatorType != OperatorType.HASH_CODE && operatorType != OperatorType.XX_HASH_64 && operatorType != OperatorType.IS_DISTINCT_FROM && operatorType != OperatorType.INDETERMINATE && operatorType != OperatorType.COMPARISON && operatorType != OperatorType.LESS_THAN && operatorType != OperatorType.LESS_THAN_OR_EQUAL ? 1 : 0) != 0, (String)"Can not register %s function: %s", (Object)operatorType, (Object)sqlFunction.getFunctionMetadata().getSignature());
            }
            Preconditions.checkArgument((!(functionMetadata = sqlFunction.getFunctionMetadata()).getSignature().getName().contains("|") ? 1 : 0) != 0, (String)"Function name cannot contain '|' character: %s", (Object)functionMetadata.getSignature());
            for (FunctionMetadata existingFunction : this.functions.list()) {
                Preconditions.checkArgument((!functionMetadata.getFunctionId().equals(existingFunction.getFunctionId()) ? 1 : 0) != 0, (String)"Function already registered: %s", (Object)functionMetadata.getFunctionId());
                Preconditions.checkArgument((!functionMetadata.getSignature().equals(existingFunction.getSignature()) ? 1 : 0) != 0, (String)"Function already registered: %s", (Object)functionMetadata.getSignature());
            }
        }
        this.functions = new FunctionMap(this.functions, functions);
    }

    public List<FunctionMetadata> list() {
        return this.functions.list();
    }

    public Collection<FunctionMetadata> get(QualifiedName name) {
        return this.functions.get(name);
    }

    public FunctionMetadata get(FunctionId functionId) {
        return this.functions.get(functionId).getFunctionMetadata();
    }

    public AggregationFunctionMetadata getAggregationFunctionMetadata(FunctionBinding functionBinding) {
        SqlFunction function = this.functions.get(functionBinding.getFunctionId());
        Preconditions.checkArgument((boolean)(function instanceof SqlAggregationFunction), (String)"%s is not an aggregation function", (Object)functionBinding.getBoundSignature());
        SqlAggregationFunction aggregationFunction = (SqlAggregationFunction)function;
        return aggregationFunction.getAggregationMetadata(functionBinding);
    }

    public WindowFunctionSupplier getWindowFunctionImplementation(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        SqlFunction function = this.functions.get(functionBinding.getFunctionId());
        try {
            if (function instanceof SqlAggregationFunction) {
                InternalAggregationFunction aggregationFunction = (InternalAggregationFunction)this.specializedAggregationCache.get((Object)functionBinding, () -> this.specializedAggregation(functionBinding, functionDependencies));
                return AggregateWindowFunction.supplier(function.getFunctionMetadata().getSignature(), aggregationFunction);
            }
            return (WindowFunctionSupplier)this.specializedWindowCache.get((Object)functionBinding, () -> this.specializeWindow(functionBinding, functionDependencies));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private WindowFunctionSupplier specializeWindow(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        SqlWindowFunction function = (SqlWindowFunction)this.functions.get(functionBinding.getFunctionId());
        return function.specialize(functionBinding, functionDependencies);
    }

    public InternalAggregationFunction getAggregateFunctionImplementation(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        try {
            return (InternalAggregationFunction)this.specializedAggregationCache.get((Object)functionBinding, () -> this.specializedAggregation(functionBinding, functionDependencies));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private InternalAggregationFunction specializedAggregation(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        SqlAggregationFunction function = (SqlAggregationFunction)this.functions.get(functionBinding.getFunctionId());
        return function.specialize(functionBinding, functionDependencies);
    }

    public FunctionDependencyDeclaration getFunctionDependencies(FunctionBinding functionBinding) {
        SqlFunction function = this.functions.get(functionBinding.getFunctionId());
        return function.getFunctionDependencies(functionBinding);
    }

    public FunctionInvoker getScalarFunctionInvoker(FunctionBinding functionBinding, FunctionDependencies functionDependencies, InvocationConvention invocationConvention) {
        ScalarFunctionImplementation scalarFunctionImplementation;
        try {
            scalarFunctionImplementation = (ScalarFunctionImplementation)this.specializedScalarCache.get((Object)functionBinding, () -> this.specializeScalarFunction(functionBinding, functionDependencies));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new RuntimeException(e.getCause());
        }
        return scalarFunctionImplementation.getScalarFunctionInvoker(invocationConvention);
    }

    private ScalarFunctionImplementation specializeScalarFunction(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        SqlScalarFunction function = (SqlScalarFunction)this.functions.get(functionBinding.getFunctionId());
        return function.specialize(functionBinding, functionDependencies);
    }

    private static class FunctionMap {
        private final Map<FunctionId, SqlFunction> functions;
        private final Multimap<QualifiedName, FunctionMetadata> functionsByName;

        public FunctionMap() {
            this.functions = ImmutableMap.of();
            this.functionsByName = ImmutableListMultimap.of();
        }

        public FunctionMap(FunctionMap map, Collection<? extends SqlFunction> functions) {
            this.functions = ImmutableMap.builder().putAll(map.functions).putAll((Map)Maps.uniqueIndex(functions, function -> function.getFunctionMetadata().getFunctionId())).build();
            ImmutableListMultimap.Builder functionsByName = ImmutableListMultimap.builder().putAll(map.functionsByName);
            functions.stream().map(SqlFunction::getFunctionMetadata).forEach(functionMetadata -> functionsByName.put((Object)QualifiedName.of((String)functionMetadata.getSignature().getName()), functionMetadata));
            this.functionsByName = functionsByName.build();
            for (Map.Entry entry : this.functionsByName.asMap().entrySet()) {
                Collection values = (Collection)entry.getValue();
                long aggregations = values.stream().map(FunctionMetadata::getKind).filter(kind -> kind == FunctionKind.AGGREGATE).count();
                Preconditions.checkState((aggregations == 0L || aggregations == (long)values.size() ? 1 : 0) != 0, (String)"'%s' is both an aggregation and a scalar function", entry.getKey());
            }
        }

        public List<FunctionMetadata> list() {
            return ImmutableList.copyOf((Collection)this.functionsByName.values());
        }

        public Collection<FunctionMetadata> get(QualifiedName name) {
            return this.functionsByName.get((Object)name);
        }

        public SqlFunction get(FunctionId functionId) {
            SqlFunction sqlFunction = this.functions.get(functionId);
            Preconditions.checkArgument((sqlFunction != null ? 1 : 0) != 0, (String)"Unknown function implementation: %s", (Object)functionId);
            return sqlFunction;
        }
    }
}

