/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.Lifespan;
import io.trino.operator.BlockedReason;
import io.trino.operator.OperatorStats;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@Immutable
public class DriverStats {
    private final Lifespan lifespan;
    private final DateTime createTime;
    private final DateTime startTime;
    private final DateTime endTime;
    private final Duration queuedTime;
    private final Duration elapsedTime;
    private final DataSize userMemoryReservation;
    private final DataSize revocableMemoryReservation;
    private final DataSize systemMemoryReservation;
    private final Duration totalScheduledTime;
    private final Duration totalCpuTime;
    private final Duration totalBlockedTime;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final DataSize physicalInputDataSize;
    private final long physicalInputPositions;
    private final Duration physicalInputReadTime;
    private final DataSize internalNetworkInputDataSize;
    private final long internalNetworkInputPositions;
    private final Duration internalNetworkInputReadTime;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final Duration rawInputReadTime;
    private final DataSize processedInputDataSize;
    private final long processedInputPositions;
    private final DataSize outputDataSize;
    private final long outputPositions;
    private final DataSize physicalWrittenDataSize;
    private final List<OperatorStats> operatorStats;

    public DriverStats() {
        this.lifespan = null;
        this.createTime = DateTime.now();
        this.startTime = null;
        this.endTime = null;
        this.queuedTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.elapsedTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.userMemoryReservation = DataSize.ofBytes((long)0L);
        this.revocableMemoryReservation = DataSize.ofBytes((long)0L);
        this.systemMemoryReservation = DataSize.ofBytes((long)0L);
        this.totalScheduledTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.totalCpuTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.totalBlockedTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.fullyBlocked = false;
        this.blockedReasons = ImmutableSet.of();
        this.physicalInputDataSize = DataSize.ofBytes((long)0L);
        this.physicalInputPositions = 0L;
        this.physicalInputReadTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.internalNetworkInputDataSize = DataSize.ofBytes((long)0L);
        this.internalNetworkInputPositions = 0L;
        this.internalNetworkInputReadTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.rawInputDataSize = DataSize.ofBytes((long)0L);
        this.rawInputPositions = 0L;
        this.rawInputReadTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.processedInputDataSize = DataSize.ofBytes((long)0L);
        this.processedInputPositions = 0L;
        this.outputDataSize = DataSize.ofBytes((long)0L);
        this.outputPositions = 0L;
        this.physicalWrittenDataSize = DataSize.ofBytes((long)0L);
        this.operatorStats = ImmutableList.of();
    }

    @JsonCreator
    public DriverStats(@JsonProperty(value="lifespan") Lifespan lifespan, @JsonProperty(value="createTime") DateTime createTime, @JsonProperty(value="startTime") DateTime startTime, @JsonProperty(value="endTime") DateTime endTime, @JsonProperty(value="queuedTime") Duration queuedTime, @JsonProperty(value="elapsedTime") Duration elapsedTime, @JsonProperty(value="userMemoryReservation") DataSize userMemoryReservation, @JsonProperty(value="revocableMemoryReservation") DataSize revocableMemoryReservation, @JsonProperty(value="systemMemoryReservation") DataSize systemMemoryReservation, @JsonProperty(value="totalScheduledTime") Duration totalScheduledTime, @JsonProperty(value="totalCpuTime") Duration totalCpuTime, @JsonProperty(value="totalBlockedTime") Duration totalBlockedTime, @JsonProperty(value="fullyBlocked") boolean fullyBlocked, @JsonProperty(value="blockedReasons") Set<BlockedReason> blockedReasons, @JsonProperty(value="physicalInputDataSize") DataSize physicalInputDataSize, @JsonProperty(value="physicalInputPositions") long physicalInputPositions, @JsonProperty(value="physicalInputReadTime") Duration physicalInputReadTime, @JsonProperty(value="internalNetworkInputDataSize") DataSize internalNetworkInputDataSize, @JsonProperty(value="internalNetworkInputPositions") long internalNetworkInputPositions, @JsonProperty(value="internalNetworkInputReadTime") Duration internalNetworkInputReadTime, @JsonProperty(value="rawInputDataSize") DataSize rawInputDataSize, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="rawInputReadTime") Duration rawInputReadTime, @JsonProperty(value="processedInputDataSize") DataSize processedInputDataSize, @JsonProperty(value="processedInputPositions") long processedInputPositions, @JsonProperty(value="outputDataSize") DataSize outputDataSize, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="physicalWrittenDataSize") DataSize physicalWrittenDataSize, @JsonProperty(value="operatorStats") List<OperatorStats> operatorStats) {
        this.lifespan = lifespan;
        this.createTime = Objects.requireNonNull(createTime, "createTime is null");
        this.startTime = startTime;
        this.endTime = endTime;
        this.queuedTime = Objects.requireNonNull(queuedTime, "queuedTime is null");
        this.elapsedTime = Objects.requireNonNull(elapsedTime, "elapsedTime is null");
        this.userMemoryReservation = Objects.requireNonNull(userMemoryReservation, "userMemoryReservation is null");
        this.revocableMemoryReservation = Objects.requireNonNull(revocableMemoryReservation, "revocableMemoryReservation is null");
        this.systemMemoryReservation = Objects.requireNonNull(systemMemoryReservation, "systemMemoryReservation is null");
        this.totalScheduledTime = Objects.requireNonNull(totalScheduledTime, "totalScheduledTime is null");
        this.totalCpuTime = Objects.requireNonNull(totalCpuTime, "totalCpuTime is null");
        this.totalBlockedTime = Objects.requireNonNull(totalBlockedTime, "totalBlockedTime is null");
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.physicalInputDataSize = Objects.requireNonNull(physicalInputDataSize, "physicalInputDataSize is null");
        Preconditions.checkArgument((physicalInputPositions >= 0L ? 1 : 0) != 0, (Object)"physicalInputPositions is negative");
        this.physicalInputPositions = physicalInputPositions;
        this.physicalInputReadTime = Objects.requireNonNull(physicalInputReadTime, "physicalInputReadTime is null");
        this.internalNetworkInputDataSize = Objects.requireNonNull(internalNetworkInputDataSize, "internalNetworkInputDataSize is null");
        Preconditions.checkArgument((internalNetworkInputPositions >= 0L ? 1 : 0) != 0, (Object)"internalNetworkInputPositions is negative");
        this.internalNetworkInputPositions = internalNetworkInputPositions;
        this.internalNetworkInputReadTime = Objects.requireNonNull(internalNetworkInputReadTime, "internalNetworkInputReadTime is null");
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize, "rawInputDataSize is null");
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        this.rawInputReadTime = Objects.requireNonNull(rawInputReadTime, "rawInputReadTime is null");
        this.processedInputDataSize = Objects.requireNonNull(processedInputDataSize, "processedInputDataSize is null");
        Preconditions.checkArgument((processedInputPositions >= 0L ? 1 : 0) != 0, (Object)"processedInputPositions is negative");
        this.processedInputPositions = processedInputPositions;
        this.outputDataSize = Objects.requireNonNull(outputDataSize, "outputDataSize is null");
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        this.physicalWrittenDataSize = Objects.requireNonNull(physicalWrittenDataSize, "writtenDataSize is null");
        this.operatorStats = ImmutableList.copyOf((Collection)Objects.requireNonNull(operatorStats, "operatorStats is null"));
    }

    @JsonProperty
    public Lifespan getLifespan() {
        return this.lifespan;
    }

    @JsonProperty
    public DateTime getCreateTime() {
        return this.createTime;
    }

    @Nullable
    @JsonProperty
    public DateTime getStartTime() {
        return this.startTime;
    }

    @Nullable
    @JsonProperty
    public DateTime getEndTime() {
        return this.endTime;
    }

    @JsonProperty
    public Duration getQueuedTime() {
        return this.queuedTime;
    }

    @JsonProperty
    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    @JsonProperty
    public DataSize getUserMemoryReservation() {
        return this.userMemoryReservation;
    }

    @JsonProperty
    public DataSize getRevocableMemoryReservation() {
        return this.revocableMemoryReservation;
    }

    @JsonProperty
    public DataSize getSystemMemoryReservation() {
        return this.systemMemoryReservation;
    }

    @JsonProperty
    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    @JsonProperty
    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    @JsonProperty
    public Duration getTotalBlockedTime() {
        return this.totalBlockedTime;
    }

    @JsonProperty
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @JsonProperty
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @JsonProperty
    public DataSize getPhysicalInputDataSize() {
        return this.physicalInputDataSize;
    }

    @JsonProperty
    public long getPhysicalInputPositions() {
        return this.physicalInputPositions;
    }

    @JsonProperty
    public Duration getPhysicalInputReadTime() {
        return this.physicalInputReadTime;
    }

    @JsonProperty
    public DataSize getInternalNetworkInputDataSize() {
        return this.internalNetworkInputDataSize;
    }

    @JsonProperty
    public long getInternalNetworkInputPositions() {
        return this.internalNetworkInputPositions;
    }

    @JsonProperty
    public Duration getInternalNetworkInputReadTime() {
        return this.internalNetworkInputReadTime;
    }

    @JsonProperty
    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    @JsonProperty
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    public Duration getRawInputReadTime() {
        return this.rawInputReadTime;
    }

    @JsonProperty
    public DataSize getProcessedInputDataSize() {
        return this.processedInputDataSize;
    }

    @JsonProperty
    public long getProcessedInputPositions() {
        return this.processedInputPositions;
    }

    @JsonProperty
    public DataSize getOutputDataSize() {
        return this.outputDataSize;
    }

    @JsonProperty
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    public DataSize getPhysicalWrittenDataSize() {
        return this.physicalWrittenDataSize;
    }

    @JsonProperty
    public List<OperatorStats> getOperatorStats() {
        return this.operatorStats;
    }
}

