/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.http.client.HttpClient;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.buffer.PageCodecMarker;
import io.trino.execution.buffer.SerializedPage;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.ExchangeClientStatus;
import io.trino.operator.HttpPageBufferClient;
import io.trino.operator.PageBufferClientStatus;
import io.trino.operator.WorkProcessor;
import io.trino.sql.analyzer.FeaturesConfig;
import java.io.Closeable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ExchangeClient
implements Closeable {
    private static final SerializedPage NO_MORE_PAGES = new SerializedPage(Slices.EMPTY_SLICE, PageCodecMarker.MarkerSet.empty(), 0, 0);
    private static final ListenableFuture<?> NOT_BLOCKED = Futures.immediateFuture(null);
    private final String selfAddress;
    private final FeaturesConfig.DataIntegrityVerification dataIntegrityVerification;
    private final long bufferCapacity;
    private final DataSize maxResponseSize;
    private final int concurrentRequestMultiplier;
    private final Duration maxErrorDuration;
    private final boolean acknowledgePages;
    private final HttpClient httpClient;
    private final ScheduledExecutorService scheduler;
    @GuardedBy(value="this")
    private boolean noMoreLocations;
    private final ConcurrentMap<URI, HttpPageBufferClient> allClients = new ConcurrentHashMap<URI, HttpPageBufferClient>();
    @GuardedBy(value="this")
    private final Deque<HttpPageBufferClient> queuedClients = new LinkedList<HttpPageBufferClient>();
    private final Set<HttpPageBufferClient> completedClients = Sets.newConcurrentHashSet();
    private final LinkedBlockingDeque<SerializedPage> pageBuffer = new LinkedBlockingDeque();
    @GuardedBy(value="this")
    private final List<SettableFuture<?>> blockedCallers = new ArrayList();
    @GuardedBy(value="this")
    private long bufferRetainedSizeInBytes;
    @GuardedBy(value="this")
    private long maxBufferRetainedSizeInBytes;
    @GuardedBy(value="this")
    private long successfulRequests;
    @GuardedBy(value="this")
    private long averageBytesPerRequest;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicReference<Throwable> failure = new AtomicReference();
    private final LocalMemoryContext systemMemoryContext;
    private final Executor pageBufferClientCallbackExecutor;

    public ExchangeClient(String selfAddress, FeaturesConfig.DataIntegrityVerification dataIntegrityVerification, DataSize bufferCapacity, DataSize maxResponseSize, int concurrentRequestMultiplier, Duration maxErrorDuration, boolean acknowledgePages, HttpClient httpClient, ScheduledExecutorService scheduler, LocalMemoryContext systemMemoryContext, Executor pageBufferClientCallbackExecutor) {
        this.selfAddress = Objects.requireNonNull(selfAddress, "selfAddress is null");
        this.dataIntegrityVerification = Objects.requireNonNull(dataIntegrityVerification, "dataIntegrityVerification is null");
        this.bufferCapacity = bufferCapacity.toBytes();
        this.maxResponseSize = maxResponseSize;
        this.concurrentRequestMultiplier = concurrentRequestMultiplier;
        this.maxErrorDuration = maxErrorDuration;
        this.acknowledgePages = acknowledgePages;
        this.httpClient = httpClient;
        this.scheduler = scheduler;
        this.systemMemoryContext = systemMemoryContext;
        this.maxBufferRetainedSizeInBytes = Long.MIN_VALUE;
        this.pageBufferClientCallbackExecutor = Objects.requireNonNull(pageBufferClientCallbackExecutor, "pageBufferClientCallbackExecutor is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExchangeClientStatus getStatus() {
        ImmutableList.Builder pageBufferClientStatusBuilder = ImmutableList.builder();
        for (HttpPageBufferClient client : this.allClients.values()) {
            pageBufferClientStatusBuilder.add((Object)client.getStatus());
        }
        ImmutableList pageBufferClientStatus = pageBufferClientStatusBuilder.build();
        ExchangeClient exchangeClient = this;
        synchronized (exchangeClient) {
            int bufferedPages = this.pageBuffer.size();
            if (bufferedPages > 0 && this.pageBuffer.peekLast() == NO_MORE_PAGES) {
                --bufferedPages;
            }
            return new ExchangeClientStatus(this.bufferRetainedSizeInBytes, this.maxBufferRetainedSizeInBytes, this.averageBytesPerRequest, this.successfulRequests, bufferedPages, this.noMoreLocations, (List<PageBufferClientStatus>)pageBufferClientStatus);
        }
    }

    public synchronized void addLocation(URI location) {
        Objects.requireNonNull(location, "location is null");
        if (this.closed.get()) {
            return;
        }
        if (this.allClients.containsKey(location)) {
            return;
        }
        Preconditions.checkState((!this.noMoreLocations ? 1 : 0) != 0, (Object)"No more locations already set");
        HttpPageBufferClient client = new HttpPageBufferClient(this.selfAddress, this.httpClient, this.dataIntegrityVerification, this.maxResponseSize, this.maxErrorDuration, this.acknowledgePages, location, new ExchangeClientCallback(), this.scheduler, this.pageBufferClientCallbackExecutor);
        this.allClients.put(location, client);
        this.queuedClients.add(client);
        this.scheduleRequestIfNecessary();
    }

    public synchronized void noMoreLocations() {
        this.noMoreLocations = true;
        this.scheduleRequestIfNecessary();
    }

    public WorkProcessor<SerializedPage> pages() {
        return WorkProcessor.create(() -> {
            SerializedPage page = this.pollPage();
            if (page == null) {
                if (this.isFinished()) {
                    return WorkProcessor.ProcessState.finished();
                }
                ListenableFuture<?> blocked = this.isBlocked();
                if (!blocked.isDone()) {
                    return WorkProcessor.ProcessState.blocked(blocked);
                }
                return WorkProcessor.ProcessState.yield();
            }
            return WorkProcessor.ProcessState.ofResult(page);
        });
    }

    private void assertNotHoldsLock() {
        assert (!Thread.holdsLock(this)) : "Cannot get next page while holding a lock on this";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SerializedPage pollPage() {
        this.assertNotHoldsLock();
        this.throwIfFailed();
        if (this.closed.get()) {
            return null;
        }
        SerializedPage page = this.pageBuffer.poll();
        if (page == null) {
            return null;
        }
        if (page == NO_MORE_PAGES) {
            this.close();
            this.notifyBlockedCallers();
            return null;
        }
        ExchangeClient exchangeClient = this;
        synchronized (exchangeClient) {
            if (!this.closed.get()) {
                this.bufferRetainedSizeInBytes -= page.getRetainedSizeInBytes();
                this.systemMemoryContext.setBytes(this.bufferRetainedSizeInBytes);
            }
            this.scheduleRequestIfNecessary();
        }
        return page;
    }

    public boolean isFinished() {
        this.throwIfFailed();
        return this.isClosed() && this.completedClients.size() == this.allClients.size();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public synchronized void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        for (HttpPageBufferClient client : this.allClients.values()) {
            ExchangeClient.closeQuietly(client);
        }
        this.pageBuffer.clear();
        this.systemMemoryContext.setBytes(0L);
        this.bufferRetainedSizeInBytes = 0L;
        if (this.pageBuffer.peekLast() != NO_MORE_PAGES) {
            Preconditions.checkState((boolean)this.pageBuffer.add(NO_MORE_PAGES), (Object)"Could not add no more pages marker");
        }
        this.notifyBlockedCallers();
    }

    public synchronized void scheduleRequestIfNecessary() {
        if (this.isFinished() || this.isFailed()) {
            return;
        }
        if (this.noMoreLocations && this.completedClients.size() == this.allClients.size()) {
            if (this.pageBuffer.peekLast() != NO_MORE_PAGES) {
                Preconditions.checkState((boolean)this.pageBuffer.add(NO_MORE_PAGES), (Object)"Could not add no more pages marker");
            }
            if (this.pageBuffer.peek() == NO_MORE_PAGES) {
                this.close();
            }
            this.notifyBlockedCallers();
            return;
        }
        long neededBytes = this.bufferCapacity - this.bufferRetainedSizeInBytes;
        if (neededBytes <= 0L) {
            return;
        }
        int clientCount = (int)(1.0 * (double)neededBytes / (double)this.averageBytesPerRequest * (double)this.concurrentRequestMultiplier);
        clientCount = Math.max(clientCount, 1);
        int pendingClients = this.allClients.size() - this.queuedClients.size() - this.completedClients.size();
        clientCount -= pendingClients;
        for (int i = 0; i < clientCount; ++i) {
            HttpPageBufferClient client = this.queuedClients.poll();
            if (client == null) {
                return;
            }
            client.scheduleRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> isBlocked() {
        if (this.isClosed() || this.isFailed() || this.pageBuffer.peek() != null) {
            return NOT_BLOCKED;
        }
        ExchangeClient exchangeClient = this;
        synchronized (exchangeClient) {
            if (this.isClosed() || this.isFailed() || this.pageBuffer.peek() != null) {
                return NOT_BLOCKED;
            }
            SettableFuture future = SettableFuture.create();
            this.blockedCallers.add(future);
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addPages(List<SerializedPage> pages) {
        long pagesRetainedSizeInBytes = 0L;
        long responseSize = 0L;
        for (SerializedPage page : pages) {
            pagesRetainedSizeInBytes += page.getRetainedSizeInBytes();
            responseSize += (long)page.getSizeInBytes();
        }
        ImmutableList notify = ImmutableList.of();
        ExchangeClient exchangeClient = this;
        synchronized (exchangeClient) {
            if (this.isClosed() || this.isFailed()) {
                return false;
            }
            if (!pages.isEmpty()) {
                this.pageBuffer.addAll(pages);
                this.bufferRetainedSizeInBytes += pagesRetainedSizeInBytes;
                this.maxBufferRetainedSizeInBytes = Math.max(this.maxBufferRetainedSizeInBytes, this.bufferRetainedSizeInBytes);
                this.systemMemoryContext.setBytes(this.bufferRetainedSizeInBytes);
                notify = ImmutableList.copyOf(this.blockedCallers);
                this.blockedCallers.clear();
            }
            ++this.successfulRequests;
            this.averageBytesPerRequest = (long)(1.0 * (double)this.averageBytesPerRequest * (double)(this.successfulRequests - 1L) / (double)this.successfulRequests + (double)(responseSize / this.successfulRequests));
        }
        this.notifyListeners((List<SettableFuture<?>>)notify);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBlockedCallers() {
        ImmutableList callers;
        ExchangeClient exchangeClient = this;
        synchronized (exchangeClient) {
            callers = ImmutableList.copyOf(this.blockedCallers);
            this.blockedCallers.clear();
        }
        this.notifyListeners((List<SettableFuture<?>>)callers);
    }

    private void notifyListeners(List<SettableFuture<?>> blockedCallers) {
        for (SettableFuture<?> blockedCaller : blockedCallers) {
            this.scheduler.execute(() -> blockedCaller.set(null));
        }
    }

    private synchronized void requestComplete(HttpPageBufferClient client) {
        if (!this.queuedClients.contains(client)) {
            this.queuedClients.add(client);
        }
        this.scheduleRequestIfNecessary();
    }

    private synchronized void clientFinished(HttpPageBufferClient client) {
        Objects.requireNonNull(client, "client is null");
        this.completedClients.add(client);
        this.scheduleRequestIfNecessary();
    }

    private synchronized void clientFailed(Throwable cause) {
        if (!this.isClosed()) {
            this.failure.compareAndSet(null, cause);
            this.notifyBlockedCallers();
        }
    }

    private boolean isFailed() {
        return this.failure.get() != null;
    }

    private void throwIfFailed() {
        Throwable t = this.failure.get();
        if (t != null) {
            Throwables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException(t);
        }
    }

    private static void closeQuietly(HttpPageBufferClient client) {
        try {
            client.close();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private class ExchangeClientCallback
    implements HttpPageBufferClient.ClientCallback {
        private ExchangeClientCallback() {
        }

        @Override
        public boolean addPages(HttpPageBufferClient client, List<SerializedPage> pages) {
            Objects.requireNonNull(client, "client is null");
            Objects.requireNonNull(pages, "pages is null");
            return ExchangeClient.this.addPages(pages);
        }

        @Override
        public void requestComplete(HttpPageBufferClient client) {
            Objects.requireNonNull(client, "client is null");
            ExchangeClient.this.requestComplete(client);
        }

        @Override
        public void clientFinished(HttpPageBufferClient client) {
            ExchangeClient.this.clientFinished(client);
        }

        @Override
        public void clientFailed(HttpPageBufferClient client, Throwable cause) {
            Objects.requireNonNull(client, "client is null");
            Objects.requireNonNull(cause, "cause is null");
            ExchangeClient.this.clientFailed(cause);
        }
    }
}

