/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.trino.operator.LookupSource;
import io.trino.operator.OuterPositionIterator;
import io.trino.operator.TrackingLookupSourceSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@NotThreadSafe
public final class OuterLookupSource
implements LookupSource {
    private final LookupSource lookupSource;
    private final OuterPositionTracker outerPositionTracker;

    public static TrackingLookupSourceSupplier createOuterLookupSourceSupplier(Supplier<LookupSource> lookupSourceSupplier) {
        return new OuterLookupSourceSupplier(lookupSourceSupplier);
    }

    private OuterLookupSource(LookupSource lookupSource, OuterPositionTracker outerPositionTracker) {
        this.lookupSource = Objects.requireNonNull(lookupSource, "lookupSource is null");
        this.outerPositionTracker = Objects.requireNonNull(outerPositionTracker, "outerPositionTracker is null");
    }

    @Override
    public boolean isEmpty() {
        return this.lookupSource.isEmpty();
    }

    @Override
    public int getChannelCount() {
        return this.lookupSource.getChannelCount();
    }

    @Override
    public long getJoinPositionCount() {
        return this.lookupSource.getJoinPositionCount();
    }

    @Override
    public long getInMemorySizeInBytes() {
        return this.lookupSource.getInMemorySizeInBytes();
    }

    @Override
    public long joinPositionWithinPartition(long joinPosition) {
        return this.lookupSource.joinPositionWithinPartition(joinPosition);
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage, long rawHash) {
        return this.lookupSource.getJoinPosition(position, hashChannelsPage, allChannelsPage, rawHash);
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage) {
        return this.lookupSource.getJoinPosition(position, hashChannelsPage, allChannelsPage);
    }

    @Override
    public long getNextJoinPosition(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        return this.lookupSource.getNextJoinPosition(currentJoinPosition, probePosition, allProbeChannelsPage);
    }

    @Override
    public boolean isJoinPositionEligible(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        return this.lookupSource.isJoinPositionEligible(currentJoinPosition, probePosition, allProbeChannelsPage);
    }

    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        this.lookupSource.appendTo(position, pageBuilder, outputChannelOffset);
        this.outerPositionTracker.positionVisited(position);
    }

    @Override
    public void close() {
        this.lookupSource.close();
    }

    @ThreadSafe
    private static class OuterPositionTracker {
        private final Supplier<LookupSource> lookupSourceSupplier;
        @GuardedBy(value="this")
        private final boolean[] visitedPositions;
        @GuardedBy(value="this")
        private boolean finished;

        public OuterPositionTracker(Supplier<LookupSource> lookupSourceSupplier) {
            this.lookupSourceSupplier = lookupSourceSupplier;
            try (LookupSource lookupSource = lookupSourceSupplier.get();){
                this.visitedPositions = new boolean[Math.toIntExact(lookupSource.getJoinPositionCount())];
            }
        }

        public synchronized void positionVisited(long position) {
            Verify.verify((!this.finished ? 1 : 0) != 0);
            this.visitedPositions[Math.toIntExact((long)position)] = true;
        }

        public synchronized OuterPositionIterator getOuterPositionIterator() {
            this.finished = true;
            return new SharedLookupOuterPositionIterator(this.lookupSourceSupplier.get(), this.visitedPositions);
        }
    }

    @ThreadSafe
    private static class OuterLookupSourceSupplier
    implements TrackingLookupSourceSupplier {
        private final Supplier<LookupSource> lookupSourceSupplier;
        private final OuterPositionTracker outerPositionTracker;

        public OuterLookupSourceSupplier(Supplier<LookupSource> lookupSourceSupplier) {
            this.lookupSourceSupplier = Objects.requireNonNull(lookupSourceSupplier, "lookupSourceSupplier is null");
            this.outerPositionTracker = new OuterPositionTracker(lookupSourceSupplier);
        }

        @Override
        public LookupSource getLookupSource() {
            return new OuterLookupSource(this.lookupSourceSupplier.get(), this.outerPositionTracker);
        }

        @Override
        public OuterPositionIterator getOuterPositionIterator() {
            return this.outerPositionTracker.getOuterPositionIterator();
        }
    }

    @ThreadSafe
    private static class SharedLookupOuterPositionIterator
    implements OuterPositionIterator {
        private final LookupSource lookupSource;
        private final boolean[] visitedPositions;
        @GuardedBy(value="this")
        private int currentPosition;

        public SharedLookupOuterPositionIterator(LookupSource lookupSource, boolean[] visitedPositions) {
            this.lookupSource = Objects.requireNonNull(lookupSource, "lookupSource is null");
            this.visitedPositions = Objects.requireNonNull(visitedPositions, "visitedPositions is null");
            Preconditions.checkArgument((lookupSource.getJoinPositionCount() == (long)visitedPositions.length ? 1 : 0) != 0);
        }

        @Override
        public synchronized boolean appendToNext(PageBuilder pageBuilder, int outputChannelOffset) {
            while (this.currentPosition < this.visitedPositions.length) {
                if (!this.visitedPositions[this.currentPosition]) {
                    this.lookupSource.appendTo(this.currentPosition, pageBuilder, outputChannelOffset);
                    ++this.currentPosition;
                    return true;
                }
                ++this.currentPosition;
            }
            return false;
        }
    }
}

