/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.LongConsumer;

public final class PageUtils {
    private PageUtils() {
    }

    public static void recordMaterializedBytes(Page page, LongConsumer sizeInBytesConsumer) {
        long loadedBlocksSizeInBytes = 0L;
        for (int i = 0; i < page.getChannelCount(); ++i) {
            Block block = page.getBlock(i);
            long initialSize = block.getSizeInBytes();
            loadedBlocksSizeInBytes += initialSize;
            LazyBlock.listenForLoads((Block)block, (Consumer)new BlockSizeListener(block, sizeInBytesConsumer, initialSize));
        }
        if (loadedBlocksSizeInBytes > 0L) {
            sizeInBytesConsumer.accept(loadedBlocksSizeInBytes);
        }
    }

    private static class BlockSizeListener
    implements Consumer<Block> {
        private final Block topLevelBlock;
        private final LongConsumer sizeInBytesConsumer;
        private long lastSize;

        public BlockSizeListener(Block topLevelBlock, LongConsumer sizeInBytesConsumer, long initialSize) {
            this.topLevelBlock = Objects.requireNonNull(topLevelBlock, "topLevelBlock is null");
            this.sizeInBytesConsumer = Objects.requireNonNull(sizeInBytesConsumer, "sizeInBytesConsumer is null");
            this.lastSize = initialSize;
        }

        @Override
        public void accept(Block childBlock) {
            long newSize = this.topLevelBlock.getSizeInBytes();
            if (newSize == this.lastSize) {
                return;
            }
            this.sizeInBytesConsumer.accept(newSize - this.lastSize);
            this.lastSize = newSize;
        }
    }
}

