/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCPoint;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.trino.Session;
import io.trino.geospatial.Rectangle;
import io.trino.geospatial.serde.GeometrySerde;
import io.trino.operator.JoinFilterFunction;
import io.trino.operator.JoinUtils;
import io.trino.operator.PagesSpatialIndex;
import io.trino.operator.SpatialIndexBuilderOperator;
import io.trino.operator.SyntheticAddress;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.JoinFilterFunctionCompiler;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import org.locationtech.jts.index.strtree.STRtree;
import org.openjdk.jol.info.ClassLayout;

public class PagesRTreeIndex
implements PagesSpatialIndex {
    private static final int[] EMPTY_ADDRESSES = new int[0];
    private final LongArrayList addresses;
    private final List<Type> types;
    private final List<Integer> outputChannels;
    private final List<List<Block>> channels;
    private final STRtree rtree;
    private final int radiusChannel;
    private final SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest;
    private final JoinFilterFunction filterFunction;
    private final Map<Integer, Rectangle> partitions;

    public PagesRTreeIndex(Session session, LongArrayList addresses, List<Type> types, List<Integer> outputChannels, List<List<Block>> channels, STRtree rtree, Optional<Integer> radiusChannel, SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, Map<Integer, Rectangle> partitions) {
        this.addresses = Objects.requireNonNull(addresses, "addresses is null");
        this.types = types;
        this.outputChannels = outputChannels;
        this.channels = Objects.requireNonNull(channels, "channels is null");
        this.rtree = Objects.requireNonNull(rtree, "rtree is null");
        this.radiusChannel = radiusChannel.orElse(-1);
        this.spatialRelationshipTest = Objects.requireNonNull(spatialRelationshipTest, "spatial relationship is null");
        this.filterFunction = filterFunctionFactory.map(factory -> factory.create(session.toConnectorSession(), addresses, JoinUtils.channelsToPages(channels))).orElse(null);
        this.partitions = Objects.requireNonNull(partitions, "partitions is null");
    }

    private static org.locationtech.jts.geom.Envelope getEnvelope(OGCGeometry ogcGeometry) {
        Envelope env = new Envelope();
        ogcGeometry.getEsriGeometry().queryEnvelope(env);
        return new org.locationtech.jts.geom.Envelope(env.getXMin(), env.getXMax(), env.getYMin(), env.getYMax());
    }

    @Override
    public int[] findJoinPositions(int probePosition, Page probe, int probeGeometryChannel, Optional<Integer> probePartitionChannel) {
        Block probeGeometryBlock = probe.getBlock(probeGeometryChannel);
        if (probeGeometryBlock.isNull(probePosition)) {
            return EMPTY_ADDRESSES;
        }
        int probePartition = probePartitionChannel.map(channel -> Math.toIntExact(IntegerType.INTEGER.getLong(probe.getBlock(channel.intValue()), probePosition))).orElse(-1);
        Slice slice = probeGeometryBlock.getSlice(probePosition, 0, probeGeometryBlock.getSliceLength(probePosition));
        OGCGeometry probeGeometry = GeometrySerde.deserialize((Slice)slice);
        Verify.verifyNotNull((Object)probeGeometry);
        if (probeGeometry.isEmpty()) {
            return EMPTY_ADDRESSES;
        }
        boolean probeIsPoint = probeGeometry instanceof OGCPoint;
        IntArrayList matchingPositions = new IntArrayList();
        org.locationtech.jts.geom.Envelope envelope = PagesRTreeIndex.getEnvelope(probeGeometry);
        this.rtree.query(envelope, item -> {
            GeometryWithPosition geometryWithPosition = (GeometryWithPosition)item;
            OGCGeometry buildGeometry = geometryWithPosition.getGeometry();
            if (this.partitions.isEmpty() || probePartition == geometryWithPosition.getPartition() && (probeIsPoint || buildGeometry instanceof OGCPoint || this.testReferencePoint(envelope, buildGeometry, probePartition))) {
                if (this.radiusChannel == -1) {
                    if (this.spatialRelationshipTest.apply(buildGeometry, probeGeometry, OptionalDouble.empty())) {
                        matchingPositions.add(geometryWithPosition.getPosition());
                    }
                } else if (this.spatialRelationshipTest.apply(geometryWithPosition.getGeometry(), probeGeometry, OptionalDouble.of(this.getRadius(geometryWithPosition.getPosition())))) {
                    matchingPositions.add(geometryWithPosition.getPosition());
                }
            }
        });
        return matchingPositions.toIntArray(null);
    }

    private boolean testReferencePoint(org.locationtech.jts.geom.Envelope probeEnvelope, OGCGeometry buildGeometry, int partition) {
        org.locationtech.jts.geom.Envelope buildEnvelope = PagesRTreeIndex.getEnvelope(buildGeometry);
        org.locationtech.jts.geom.Envelope intersection = buildEnvelope.intersection(probeEnvelope);
        if (intersection.isNull()) {
            return false;
        }
        Rectangle extent = this.partitions.get(partition);
        double x = intersection.getMinX();
        double y = intersection.getMinY();
        return x >= extent.getXMin() && x < extent.getXMax() && y >= extent.getYMin() && y < extent.getYMax();
    }

    private double getRadius(int joinPosition) {
        long joinAddress = this.addresses.getLong(joinPosition);
        int blockIndex = SyntheticAddress.decodeSliceIndex(joinAddress);
        int blockPosition = SyntheticAddress.decodePosition(joinAddress);
        return DoubleType.DOUBLE.getDouble(this.channels.get(this.radiusChannel).get(blockIndex), blockPosition);
    }

    @Override
    public boolean isJoinPositionEligible(int joinPosition, int probePosition, Page probe) {
        return this.filterFunction == null || this.filterFunction.filter(joinPosition, probePosition, probe);
    }

    @Override
    public void appendTo(int joinPosition, PageBuilder pageBuilder, int outputChannelOffset) {
        long joinAddress = this.addresses.getLong(joinPosition);
        int blockIndex = SyntheticAddress.decodeSliceIndex(joinAddress);
        int blockPosition = SyntheticAddress.decodePosition(joinAddress);
        for (int outputIndex : this.outputChannels) {
            Type type = this.types.get(outputIndex);
            List<Block> channel = this.channels.get(outputIndex);
            Block block = channel.get(blockIndex);
            type.appendTo(block, blockPosition, pageBuilder.getBlockBuilder(outputChannelOffset));
            ++outputChannelOffset;
        }
    }

    public static final class GeometryWithPosition {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GeometryWithPosition.class).instanceSize();
        private final OGCGeometry ogcGeometry;
        private final int partition;
        private final int position;

        public GeometryWithPosition(OGCGeometry ogcGeometry, int partition, int position) {
            this.ogcGeometry = Objects.requireNonNull(ogcGeometry, "ogcGeometry is null");
            this.partition = partition;
            this.position = position;
        }

        public OGCGeometry getGeometry() {
            return this.ogcGeometry;
        }

        public int getPartition() {
            return this.partition;
        }

        public int getPosition() {
            return this.position;
        }

        public long getEstimatedMemorySizeInBytes() {
            return (long)INSTANCE_SIZE + this.ogcGeometry.estimateMemorySize();
        }
    }
}

