/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class StageExecutionDescriptor {
    private final StageExecutionStrategy stageExecutionStrategy;
    private final Set<PlanNodeId> groupedExecutionScanNodes;

    private StageExecutionDescriptor(StageExecutionStrategy strategy, Set<PlanNodeId> groupedExecutionScanNodes) {
        switch (strategy) {
            case UNGROUPED_EXECUTION: {
                Preconditions.checkArgument((boolean)groupedExecutionScanNodes.isEmpty(), (Object)"groupedExecutionScanNodes must be empty if stage execution strategy is ungrouped execution");
                break;
            }
            case FIXED_LIFESPAN_SCHEDULE_GROUPED_EXECUTION: 
            case DYNAMIC_LIFESPAN_SCHEDULE_GROUPED_EXECUTION: {
                Preconditions.checkArgument((!groupedExecutionScanNodes.isEmpty() ? 1 : 0) != 0, (Object)"groupedExecutionScanNodes cannot be empty if stage execution strategy is grouped execution");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported stage execution strategy: " + strategy);
            }
        }
        this.stageExecutionStrategy = Objects.requireNonNull(strategy, "strategy is null");
        this.groupedExecutionScanNodes = Objects.requireNonNull(groupedExecutionScanNodes, "groupedExecutionScanNodes is null");
    }

    public static StageExecutionDescriptor ungroupedExecution() {
        return new StageExecutionDescriptor(StageExecutionStrategy.UNGROUPED_EXECUTION, (Set<PlanNodeId>)ImmutableSet.of());
    }

    public static StageExecutionDescriptor fixedLifespanScheduleGroupedExecution(List<PlanNodeId> capableScanNodes) {
        Objects.requireNonNull(capableScanNodes, "capableScanNodes is null");
        Preconditions.checkArgument((!capableScanNodes.isEmpty() ? 1 : 0) != 0, (Object)"capableScanNodes cannot be empty if stage execution strategy is grouped execution");
        return new StageExecutionDescriptor(StageExecutionStrategy.FIXED_LIFESPAN_SCHEDULE_GROUPED_EXECUTION, (Set<PlanNodeId>)ImmutableSet.copyOf(capableScanNodes));
    }

    public static StageExecutionDescriptor dynamicLifespanScheduleGroupedExecution(List<PlanNodeId> capableScanNodes) {
        Objects.requireNonNull(capableScanNodes, "capableScanNodes is null");
        Preconditions.checkArgument((!capableScanNodes.isEmpty() ? 1 : 0) != 0, (Object)"capableScanNodes cannot be empty if stage execution strategy is grouped execution");
        return new StageExecutionDescriptor(StageExecutionStrategy.DYNAMIC_LIFESPAN_SCHEDULE_GROUPED_EXECUTION, (Set<PlanNodeId>)ImmutableSet.copyOf(capableScanNodes));
    }

    @JsonProperty(value="strategy")
    public StageExecutionStrategy getStageExecutionStrategy() {
        return this.stageExecutionStrategy;
    }

    public boolean isStageGroupedExecution() {
        return this.stageExecutionStrategy != StageExecutionStrategy.UNGROUPED_EXECUTION;
    }

    public boolean isDynamicLifespanSchedule() {
        return this.stageExecutionStrategy == StageExecutionStrategy.DYNAMIC_LIFESPAN_SCHEDULE_GROUPED_EXECUTION;
    }

    public boolean isScanGroupedExecution(PlanNodeId scanNodeId) {
        return this.groupedExecutionScanNodes.contains(scanNodeId);
    }

    @JsonCreator
    public static StageExecutionDescriptor jsonCreator(@JsonProperty(value="strategy") StageExecutionStrategy strategy, @JsonProperty(value="groupedExecutionScanNodes") Set<PlanNodeId> groupedExecutionCapableScanNodes) {
        return new StageExecutionDescriptor(Objects.requireNonNull(strategy, "strategy is null"), (Set<PlanNodeId>)ImmutableSet.copyOf((Collection)Objects.requireNonNull(groupedExecutionCapableScanNodes, "groupedExecutionScanNodes is null")));
    }

    @JsonProperty(value="groupedExecutionScanNodes")
    public Set<PlanNodeId> getJsonSerializableGroupedExecutionScanNodes() {
        return this.groupedExecutionScanNodes;
    }

    public static enum StageExecutionStrategy {
        UNGROUPED_EXECUTION,
        FIXED_LIFESPAN_SCHEDULE_GROUPED_EXECUTION,
        DYNAMIC_LIFESPAN_SCHEDULE_GROUPED_EXECUTION;

    }
}

