/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.spi.Page;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ValuesOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final Iterator<Page> pages;

    public ValuesOperator(OperatorContext operatorContext, List<Page> pages) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        Objects.requireNonNull(pages, "pages is null");
        this.pages = ImmutableList.copyOf(pages).iterator();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        Iterators.size(this.pages);
    }

    @Override
    public boolean isFinished() {
        return !this.pages.hasNext();
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (!this.pages.hasNext()) {
            return null;
        }
        Page page = this.pages.next();
        if (page != null) {
            this.operatorContext.recordProcessedInput(page.getSizeInBytes(), page.getPositionCount());
        }
        return page;
    }

    public static class ValuesOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Page> pages;
        private boolean closed;

        public ValuesOperatorFactory(int operatorId, PlanNodeId planNodeId, List<Page> pages) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.pages = ImmutableList.copyOf((Collection)Objects.requireNonNull(pages, "pages is null"));
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, ValuesOperator.class.getSimpleName());
            return new ValuesOperator(operatorContext, this.pages);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new ValuesOperatorFactory(this.operatorId, this.planNodeId, this.pages);
        }
    }
}

