/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.trino.operator.aggregation.state.NullableBooleanState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;

public class NullableBooleanStateSerializer
implements AccumulatorStateSerializer<NullableBooleanState> {
    public Type getSerializedType() {
        return BooleanType.BOOLEAN;
    }

    public void serialize(NullableBooleanState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            BooleanType.BOOLEAN.writeBoolean(out, state.getBoolean());
        }
    }

    public void deserialize(Block block, int index, NullableBooleanState state) {
        state.setNull(false);
        state.setBoolean(BooleanType.BOOLEAN.getBoolean(block, index));
    }
}

