/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.exchange;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.operator.exchange.LocalExchangeMemoryManager;
import io.trino.operator.exchange.LocalExchanger;
import io.trino.operator.exchange.PageReference;
import io.trino.spi.Page;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;

class RandomExchanger
implements LocalExchanger {
    private final List<Consumer<PageReference>> buffers;
    private final LocalExchangeMemoryManager memoryManager;
    private final PageReference.PageReleasedListener onPageReleased;

    public RandomExchanger(List<Consumer<PageReference>> buffers, LocalExchangeMemoryManager memoryManager) {
        this.buffers = ImmutableList.copyOf((Collection)Objects.requireNonNull(buffers, "buffers is null"));
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.onPageReleased = PageReference.PageReleasedListener.forLocalExchangeMemoryManager(memoryManager);
    }

    @Override
    public void accept(Page page) {
        this.memoryManager.updateMemoryUsage(page.getRetainedSizeInBytes());
        int randomIndex = ThreadLocalRandom.current().nextInt(this.buffers.size());
        this.buffers.get(randomIndex).accept(new PageReference(page, 1, this.onPageReleased));
    }

    @Override
    public ListenableFuture<?> waitForWriting() {
        return this.memoryManager.getNotFullFuture();
    }
}

