/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.LongTimestamp;

@ScalarFunction(value="to_unixtime")
public final class ToUnixTime {
    private ToUnixTime() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="double")
    public static double toUnixTime(@SqlType(value="timestamp(p)") long timestamp) {
        return (double)timestamp * 1.0 / 1000000.0;
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="double")
    public static double toUnixTime(@SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return (double)timestamp.getEpochMicros() * 1.0 / 1000000.0 + (double)timestamp.getPicosOfMicro() * 1.0 / 1.0E12;
    }
}

