/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.base.Preconditions;
import io.trino.metadata.Signature;
import io.trino.operator.aggregation.LambdaProvider;
import io.trino.operator.window.WindowFunctionSupplier;
import io.trino.spi.function.WindowFunction;
import java.util.List;
import java.util.Objects;

public abstract class AbstractWindowFunctionSupplier
implements WindowFunctionSupplier {
    private final Signature signature;
    private final String description;
    private final List<Class<?>> lambdaInterfaces;

    protected AbstractWindowFunctionSupplier(Signature signature, String description, List<Class<?>> lambdaInterfaces) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.description = description;
        this.lambdaInterfaces = lambdaInterfaces;
    }

    @Override
    public final Signature getSignature() {
        return this.signature;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public List<Class<?>> getLambdaInterfaces() {
        return this.lambdaInterfaces;
    }

    @Override
    public final WindowFunction createWindowFunction(List<Integer> argumentChannels, boolean ignoreNulls, List<LambdaProvider> lambdaProviders) {
        Objects.requireNonNull(argumentChannels, "inputs is null");
        long argumentCount = this.signature.getArgumentTypes().stream().filter(type -> !type.getBase().equalsIgnoreCase("function")).count();
        Preconditions.checkArgument(((long)argumentChannels.size() == argumentCount ? 1 : 0) != 0, (String)"Expected %s arguments for function %s, but got %s", (Object)argumentCount, (Object)this.signature.getName(), (Object)argumentChannels.size());
        return this.newWindowFunction(argumentChannels, ignoreNulls, lambdaProviders);
    }

    protected abstract WindowFunction newWindowFunction(List<Integer> var1, boolean var2, List<LambdaProvider> var3);
}

