/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.discovery.server.EmbeddedDiscoveryModule;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.json.JsonCodecBinder;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.client.QueryResults;
import io.trino.cost.CostCalculator;
import io.trino.cost.CostCalculatorUsingExchanges;
import io.trino.cost.CostCalculatorWithEstimatedExchanges;
import io.trino.cost.CostComparator;
import io.trino.cost.StatsAndCosts;
import io.trino.cost.StatsCalculatorModule;
import io.trino.cost.TaskCountEstimator;
import io.trino.dispatcher.DispatchExecutor;
import io.trino.dispatcher.DispatchManager;
import io.trino.dispatcher.DispatchQueryFactory;
import io.trino.dispatcher.FailedDispatchQueryFactory;
import io.trino.dispatcher.LocalDispatchQueryFactory;
import io.trino.dispatcher.QueuedStatementResource;
import io.trino.event.QueryMonitor;
import io.trino.event.QueryMonitorConfig;
import io.trino.execution.ClusterSizeMonitor;
import io.trino.execution.ExplainAnalyzeContext;
import io.trino.execution.ForQueryExecution;
import io.trino.execution.QueryExecution;
import io.trino.execution.QueryExecutionMBean;
import io.trino.execution.QueryIdGenerator;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryManager;
import io.trino.execution.QueryPerformanceFetcher;
import io.trino.execution.QueryPreparer;
import io.trino.execution.RemoteTaskFactory;
import io.trino.execution.SqlQueryManager;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.resourcegroups.InternalResourceGroupManager;
import io.trino.execution.resourcegroups.LegacyResourceGroupConfigurationManager;
import io.trino.execution.resourcegroups.ResourceGroupManager;
import io.trino.execution.scheduler.AllAtOnceExecutionPolicy;
import io.trino.execution.scheduler.ExecutionPolicy;
import io.trino.execution.scheduler.PhasedExecutionPolicy;
import io.trino.execution.scheduler.SplitSchedulerStats;
import io.trino.failuredetector.FailureDetectorModule;
import io.trino.memory.ClusterMemoryManager;
import io.trino.memory.ForMemoryManager;
import io.trino.memory.LowMemoryKiller;
import io.trino.memory.MemoryManagerConfig;
import io.trino.memory.NoneLowMemoryKiller;
import io.trino.memory.TotalReservationLowMemoryKiller;
import io.trino.memory.TotalReservationOnBlockedNodesLowMemoryKiller;
import io.trino.metadata.CatalogManager;
import io.trino.operator.ForScheduler;
import io.trino.server.DynamicFilterService;
import io.trino.server.EmbeddedDiscoveryConfig;
import io.trino.server.ForStatementResource;
import io.trino.server.ForWorkerInfo;
import io.trino.server.GenerateTraceTokenRequestFilter;
import io.trino.server.HttpRemoteTaskFactory;
import io.trino.server.NodeResource;
import io.trino.server.QueryExecutionFactoryModule;
import io.trino.server.QueryResource;
import io.trino.server.QuerySessionSupplier;
import io.trino.server.QueryStateInfoResource;
import io.trino.server.ResourceGroupStateInfoResource;
import io.trino.server.SessionSupplier;
import io.trino.server.StatementHttpExecutionMBean;
import io.trino.server.TaskUpdateRequest;
import io.trino.server.protocol.ExecutingStatementResource;
import io.trino.server.remotetask.RemoteTaskStats;
import io.trino.server.ui.WebUiModule;
import io.trino.server.ui.WorkerResource;
import io.trino.spi.memory.ClusterMemoryPoolManager;
import io.trino.spi.security.SelectedRole;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.planner.PlanFragmenter;
import io.trino.sql.planner.PlanOptimizers;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.transaction.ForTransactionManager;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import io.trino.transaction.TransactionManagerConfig;
import io.trino.version.EmbedVersion;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.weakref.jmx.guice.ExportBinder;

public class CoordinatorModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.install((Module)new WebUiModule());
        this.install(ConditionalModule.installModuleIf(EmbeddedDiscoveryConfig.class, EmbeddedDiscoveryConfig::isEnabled, (Module)new EmbeddedDiscoveryModule()));
        DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("trino-coordinator");
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(QueryInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(QueryResults.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(SelectedRole.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(QueuedStatementResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ExecutingStatementResource.class);
        binder.bind(StatementHttpExecutionMBean.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(StatementHttpExecutionMBean.class).withGeneratedName();
        ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(HttpServerConfig.class, config -> {
            config.setMaxRequestHeaderSize(DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
            config.setMaxResponseHeaderSize(DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        });
        binder.install((Module)new FailureDetectorModule());
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(NodeResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(WorkerResource.class);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("workerInfo", ForWorkerInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(StatsAndCosts.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(QueryMonitorConfig.class);
        binder.bind(QueryMonitor.class).in(Scopes.SINGLETON);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(QueryResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(QueryStateInfoResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ResourceGroupStateInfoResource.class);
        binder.bind(QueryIdGenerator.class).in(Scopes.SINGLETON);
        binder.bind(QueryManager.class).to(SqlQueryManager.class).in(Scopes.SINGLETON);
        binder.bind(QueryPreparer.class).in(Scopes.SINGLETON);
        binder.bind(SessionSupplier.class).to(QuerySessionSupplier.class).in(Scopes.SINGLETON);
        binder.bind(InternalResourceGroupManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(InternalResourceGroupManager.class).withGeneratedName();
        binder.bind(ResourceGroupManager.class).to(InternalResourceGroupManager.class);
        binder.bind(LegacyResourceGroupConfigurationManager.class).in(Scopes.SINGLETON);
        binder.bind(DispatchManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(DispatchManager.class).as(generator -> generator.generatedNameOf(QueryManager.class));
        binder.bind(FailedDispatchQueryFactory.class).in(Scopes.SINGLETON);
        binder.bind(DispatchExecutor.class).in(Scopes.SINGLETON);
        binder.bind(DispatchQueryFactory.class).to(LocalDispatchQueryFactory.class);
        binder.bind(ClusterMemoryManager.class).in(Scopes.SINGLETON);
        binder.bind(ClusterMemoryPoolManager.class).to(ClusterMemoryManager.class).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("memoryManager", ForMemoryManager.class).withTracing().withConfigDefaults(config -> {
            config.setIdleTimeout(new Duration(30.0, TimeUnit.SECONDS));
            config.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS));
        });
        this.bindLowMemoryKiller(MemoryManagerConfig.LowMemoryKillerPolicy.NONE, NoneLowMemoryKiller.class);
        this.bindLowMemoryKiller(MemoryManagerConfig.LowMemoryKillerPolicy.TOTAL_RESERVATION, TotalReservationLowMemoryKiller.class);
        this.bindLowMemoryKiller(MemoryManagerConfig.LowMemoryKillerPolicy.TOTAL_RESERVATION_ON_BLOCKED_NODES, TotalReservationOnBlockedNodesLowMemoryKiller.class);
        ExportBinder.newExporter((Binder)binder).export(ClusterMemoryManager.class).withGeneratedName();
        binder.bind(ClusterSizeMonitor.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ClusterSizeMonitor.class).withGeneratedName();
        binder.install((Module)new StatsCalculatorModule());
        binder.bind(TaskCountEstimator.class).in(Scopes.SINGLETON);
        binder.bind(CostCalculator.class).to(CostCalculatorUsingExchanges.class).in(Scopes.SINGLETON);
        binder.bind(CostCalculator.class).annotatedWith(CostCalculator.EstimatedExchanges.class).to(CostCalculatorWithEstimatedExchanges.class).in(Scopes.SINGLETON);
        binder.bind(CostComparator.class).in(Scopes.SINGLETON);
        binder.bind(DynamicFilterService.class).in(Scopes.SINGLETON);
        binder.bind(PlanFragmenter.class).in(Scopes.SINGLETON);
        binder.bind(PlanOptimizers.class).in(Scopes.SINGLETON);
        binder.bind(RuleStatsRecorder.class).in(Scopes.SINGLETON);
        binder.bind(QueryExplainer.class).in(Scopes.SINGLETON);
        binder.bind(ExplainAnalyzeContext.class).in(Scopes.SINGLETON);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskUpdateRequest.class);
        binder.bind(RemoteTaskFactory.class).to(HttpRemoteTaskFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(RemoteTaskFactory.class).withGeneratedName();
        binder.bind(RemoteTaskStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(RemoteTaskStats.class).withGeneratedName();
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("scheduler", ForScheduler.class).withTracing().withFilter(GenerateTraceTokenRequestFilter.class).withConfigDefaults(config -> {
            config.setIdleTimeout(new Duration(30.0, TimeUnit.SECONDS));
            config.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS));
            config.setMaxConnectionsPerServer(250);
        });
        binder.bind(ScheduledExecutorService.class).annotatedWith(ForScheduler.class).toInstance((Object)Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"stage-scheduler")));
        binder.bind(ExecutorService.class).annotatedWith(ForQueryExecution.class).toInstance((Object)Executors.newCachedThreadPool(Threads.threadsNamed((String)"query-execution-%s")));
        binder.bind(QueryExecutionMBean.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(QueryExecutionMBean.class).as(generator -> generator.generatedNameOf(QueryExecution.class));
        binder.bind(SplitSchedulerStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(SplitSchedulerStats.class).withGeneratedName();
        MapBinder executionPolicyBinder = MapBinder.newMapBinder((Binder)binder, String.class, ExecutionPolicy.class);
        executionPolicyBinder.addBinding((Object)"all-at-once").to(AllAtOnceExecutionPolicy.class);
        executionPolicyBinder.addBinding((Object)"phased").to(PhasedExecutionPolicy.class);
        this.install(new QueryExecutionFactoryModule());
        binder.bind(ExecutorCleanup.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public static ResourceGroupManager<?> getResourceGroupManager(ResourceGroupManager manager) {
        return manager;
    }

    @Provides
    @Singleton
    public static QueryPerformanceFetcher createQueryPerformanceFetcher(QueryManager queryManager) {
        return queryManager::getFullQueryInfo;
    }

    @Provides
    @Singleton
    @ForStatementResource
    public static ExecutorService createStatementResponseCoreExecutor() {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"statement-response-%s"));
    }

    @Provides
    @Singleton
    @ForStatementResource
    public static BoundedExecutor createStatementResponseExecutor(@ForStatementResource ExecutorService coreExecutor, TaskManagerConfig config) {
        return new BoundedExecutor((Executor)coreExecutor, config.getHttpResponseThreads());
    }

    @Provides
    @Singleton
    @ForStatementResource
    public static ScheduledExecutorService createStatementTimeoutExecutor(TaskManagerConfig config) {
        return Executors.newScheduledThreadPool(config.getHttpTimeoutThreads(), Threads.daemonThreadsNamed((String)"statement-timeout-%s"));
    }

    @Provides
    @Singleton
    @ForTransactionManager
    public static ScheduledExecutorService createTransactionIdleCheckExecutor() {
        return Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"transaction-idle-check"));
    }

    @Provides
    @Singleton
    @ForTransactionManager
    public static ExecutorService createTransactionFinishingExecutor() {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"transaction-finishing-%s"));
    }

    @Provides
    @Singleton
    public static TransactionManager createTransactionManager(TransactionManagerConfig config, CatalogManager catalogManager, EmbedVersion embedVersion, @ForTransactionManager ScheduledExecutorService idleCheckExecutor, @ForTransactionManager ExecutorService finishingExecutor) {
        return InMemoryTransactionManager.create(config, idleCheckExecutor, catalogManager, embedVersion.embedVersion(finishingExecutor));
    }

    private void bindLowMemoryKiller(MemoryManagerConfig.LowMemoryKillerPolicy policy, Class<? extends LowMemoryKiller> clazz) {
        this.install(ConditionalModule.installModuleIf(MemoryManagerConfig.class, config -> policy == config.getLowMemoryKillerPolicy(), binder -> binder.bind(LowMemoryKiller.class).to(clazz).in(Scopes.SINGLETON)));
    }

    public static class ExecutorCleanup {
        private final List<ExecutorService> executors;

        @Inject
        public ExecutorCleanup(@ForStatementResource ExecutorService statementResponseExecutor, @ForStatementResource ScheduledExecutorService statementTimeoutExecutor, @ForQueryExecution ExecutorService queryExecutionExecutor, @ForScheduler ScheduledExecutorService schedulerExecutor, @ForTransactionManager ExecutorService transactionFinishingExecutor, @ForTransactionManager ScheduledExecutorService transactionIdleExecutor) {
            this.executors = ImmutableList.builder().add((Object)statementResponseExecutor).add((Object)statementTimeoutExecutor).add((Object)queryExecutionExecutor).add((Object)schedulerExecutor).add((Object)transactionFinishingExecutor).add((Object)transactionIdleExecutor).build();
        }

        @PreDestroy
        public void shutdown() {
            this.executors.forEach(ExecutorService::shutdownNow);
        }
    }
}

