/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.client.ProtocolDetectionException;
import io.trino.client.ProtocolHeaders;
import io.trino.security.AccessControl;
import io.trino.server.SessionContext;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.GroupProvider;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.session.ResourceEstimates;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.parser.ParsingOptions;
import io.trino.sql.parser.SqlParser;
import io.trino.transaction.TransactionId;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public final class HttpRequestSessionContext
implements SessionContext {
    private static final Splitter DOT_SPLITTER = Splitter.on((char)'.');
    public static final String AUTHENTICATED_IDENTITY = "trino.authenticated-identity";
    private final ProtocolHeaders protocolHeaders;
    private final String catalog;
    private final String schema;
    private final String path;
    private final Optional<Identity> authenticatedIdentity;
    private final Identity identity;
    private final String source;
    private final Optional<String> traceToken;
    private final String userAgent;
    private final String remoteUserAddress;
    private final String timeZoneId;
    private final String language;
    private final Set<String> clientTags;
    private final Set<String> clientCapabilities;
    private final ResourceEstimates resourceEstimates;
    private final Map<String, String> systemProperties;
    private final Map<String, Map<String, String>> catalogSessionProperties;
    private final Map<String, String> preparedStatements;
    private final Optional<TransactionId> transactionId;
    private final boolean clientTransactionSupport;
    private final String clientInfo;

    public HttpRequestSessionContext(MultivaluedMap<String, String> headers, Optional<String> alternateHeaderName, String remoteAddress, Optional<Identity> authenticatedIdentity, GroupProvider groupProvider) throws WebApplicationException {
        try {
            this.protocolHeaders = ProtocolHeaders.detectProtocol(alternateHeaderName, (Set)headers.keySet());
        }
        catch (ProtocolDetectionException e) {
            throw HttpRequestSessionContext.badRequest(e.getMessage());
        }
        this.catalog = HttpRequestSessionContext.trimEmptyToNull((String)headers.getFirst((Object)this.protocolHeaders.requestCatalog()));
        this.schema = HttpRequestSessionContext.trimEmptyToNull((String)headers.getFirst((Object)this.protocolHeaders.requestSchema()));
        this.path = HttpRequestSessionContext.trimEmptyToNull((String)headers.getFirst((Object)this.protocolHeaders.requestPath()));
        HttpRequestSessionContext.assertRequest(this.catalog != null || this.schema == null, "Schema is set but catalog is not", new Object[0]);
        this.authenticatedIdentity = Objects.requireNonNull(authenticatedIdentity, "authenticatedIdentity is null");
        this.identity = HttpRequestSessionContext.buildSessionIdentity(authenticatedIdentity, this.protocolHeaders, headers, groupProvider);
        this.source = (String)headers.getFirst((Object)this.protocolHeaders.requestSource());
        this.traceToken = Optional.ofNullable(HttpRequestSessionContext.trimEmptyToNull((String)headers.getFirst((Object)this.protocolHeaders.requestTraceToken())));
        this.userAgent = (String)headers.getFirst((Object)"User-Agent");
        this.remoteUserAddress = remoteAddress;
        this.timeZoneId = (String)headers.getFirst((Object)this.protocolHeaders.requestTimeZone());
        this.language = (String)headers.getFirst((Object)this.protocolHeaders.requestLanguage());
        this.clientInfo = (String)headers.getFirst((Object)this.protocolHeaders.requestClientInfo());
        this.clientTags = HttpRequestSessionContext.parseClientTags(this.protocolHeaders, headers);
        this.clientCapabilities = HttpRequestSessionContext.parseClientCapabilities(this.protocolHeaders, headers);
        this.resourceEstimates = HttpRequestSessionContext.parseResourceEstimate(this.protocolHeaders, headers);
        ImmutableMap.Builder systemProperties = ImmutableMap.builder();
        HashMap<String, Map> catalogSessionProperties = new HashMap<String, Map>();
        for (Map.Entry<String, String> entry2 : HttpRequestSessionContext.parseSessionHeaders(this.protocolHeaders, headers).entrySet()) {
            String fullPropertyName = entry2.getKey();
            String propertyValue = entry2.getValue();
            List nameParts = DOT_SPLITTER.splitToList((CharSequence)fullPropertyName);
            if (nameParts.size() == 1) {
                String propertyName = (String)nameParts.get(0);
                HttpRequestSessionContext.assertRequest(!propertyName.isEmpty(), "Invalid %s header", this.protocolHeaders.requestSession());
                systemProperties.put((Object)propertyName, (Object)propertyValue);
                continue;
            }
            if (nameParts.size() == 2) {
                String catalogName = (String)nameParts.get(0);
                String propertyName = (String)nameParts.get(1);
                HttpRequestSessionContext.assertRequest(!catalogName.isEmpty(), "Invalid %s header", this.protocolHeaders.requestSession());
                HttpRequestSessionContext.assertRequest(!propertyName.isEmpty(), "Invalid %s header", this.protocolHeaders.requestSession());
                catalogSessionProperties.computeIfAbsent(catalogName, id -> new HashMap()).put(propertyName, propertyValue);
                continue;
            }
            throw HttpRequestSessionContext.badRequest(String.format("Invalid %s header", this.protocolHeaders.requestSession()));
        }
        this.systemProperties = systemProperties.build();
        this.catalogSessionProperties = (Map)catalogSessionProperties.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableMap.copyOf((Map)((Map)entry.getValue()))));
        this.preparedStatements = HttpRequestSessionContext.parsePreparedStatementsHeaders(this.protocolHeaders, headers);
        String transactionIdHeader = (String)headers.getFirst((Object)this.protocolHeaders.requestTransactionId());
        this.clientTransactionSupport = transactionIdHeader != null;
        this.transactionId = HttpRequestSessionContext.parseTransactionId(transactionIdHeader);
    }

    public static Identity extractAuthorizedIdentity(HttpServletRequest servletRequest, HttpHeaders httpHeaders, Optional<String> alternateHeaderName, AccessControl accessControl, GroupProvider groupProvider) {
        return HttpRequestSessionContext.extractAuthorizedIdentity(Optional.ofNullable((Identity)servletRequest.getAttribute(AUTHENTICATED_IDENTITY)), (MultivaluedMap<String, String>)httpHeaders.getRequestHeaders(), alternateHeaderName, accessControl, groupProvider);
    }

    public static Identity extractAuthorizedIdentity(Optional<Identity> optionalAuthenticatedIdentity, MultivaluedMap<String, String> headers, Optional<String> alternateHeaderName, AccessControl accessControl, GroupProvider groupProvider) throws AccessDeniedException {
        ProtocolHeaders protocolHeaders;
        try {
            protocolHeaders = ProtocolHeaders.detectProtocol(alternateHeaderName, (Set)headers.keySet());
        }
        catch (ProtocolDetectionException e) {
            throw HttpRequestSessionContext.badRequest(e.getMessage());
        }
        Identity identity = HttpRequestSessionContext.buildSessionIdentity(optionalAuthenticatedIdentity, protocolHeaders, headers, groupProvider);
        accessControl.checkCanSetUser(identity.getPrincipal(), identity.getUser());
        optionalAuthenticatedIdentity.ifPresent(authenticatedIdentity -> {
            if (!authenticatedIdentity.getUser().equals(identity.getUser())) {
                accessControl.checkCanImpersonateUser((Identity)authenticatedIdentity, identity.getUser());
            }
        });
        return identity;
    }

    private static Identity buildSessionIdentity(Optional<Identity> authenticatedIdentity, ProtocolHeaders protocolHeaders, MultivaluedMap<String, String> headers, GroupProvider groupProvider) {
        String trinoUser = HttpRequestSessionContext.trimEmptyToNull((String)headers.getFirst((Object)protocolHeaders.requestUser()));
        String user = trinoUser != null ? trinoUser : (String)authenticatedIdentity.map(Identity::getUser).orElse(null);
        HttpRequestSessionContext.assertRequest(user != null, "User must be set", new Object[0]);
        return authenticatedIdentity.map(identity -> Identity.from((Identity)identity).withUser(user)).orElseGet(() -> Identity.forUser((String)user)).withAdditionalRoles(HttpRequestSessionContext.parseRoleHeaders(protocolHeaders, headers)).withAdditionalExtraCredentials(HttpRequestSessionContext.parseExtraCredentials(protocolHeaders, headers)).withAdditionalGroups(groupProvider.getGroups(user)).build();
    }

    @Override
    public ProtocolHeaders getProtocolHeaders() {
        return this.protocolHeaders;
    }

    @Override
    public Optional<Identity> getAuthenticatedIdentity() {
        return this.authenticatedIdentity;
    }

    @Override
    public Identity getIdentity() {
        return this.identity;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getRemoteUserAddress() {
        return this.remoteUserAddress;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public String getClientInfo() {
        return this.clientInfo;
    }

    @Override
    public Set<String> getClientTags() {
        return this.clientTags;
    }

    @Override
    public Set<String> getClientCapabilities() {
        return this.clientCapabilities;
    }

    @Override
    public ResourceEstimates getResourceEstimates() {
        return this.resourceEstimates;
    }

    @Override
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public Map<String, Map<String, String>> getCatalogSessionProperties() {
        return this.catalogSessionProperties;
    }

    @Override
    public Map<String, String> getPreparedStatements() {
        return this.preparedStatements;
    }

    @Override
    public Optional<TransactionId> getTransactionId() {
        return this.transactionId;
    }

    @Override
    public boolean supportClientTransaction() {
        return this.clientTransactionSupport;
    }

    @Override
    public Optional<String> getTraceToken() {
        return this.traceToken;
    }

    private static List<String> splitHttpHeader(MultivaluedMap<String, String> headers, String name) {
        List values = (List)MoreObjects.firstNonNull((Object)((List)headers.get((Object)name)), (Object)ImmutableList.of());
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        return (List)values.stream().map(arg_0 -> ((Splitter)splitter).splitToList(arg_0)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    private static Map<String, String> parseSessionHeaders(ProtocolHeaders protocolHeaders, MultivaluedMap<String, String> headers) {
        return HttpRequestSessionContext.parseProperty(headers, protocolHeaders.requestSession());
    }

    private static Map<String, SelectedRole> parseRoleHeaders(ProtocolHeaders protocolHeaders, MultivaluedMap<String, String> headers) {
        ImmutableMap.Builder roles = ImmutableMap.builder();
        HttpRequestSessionContext.parseProperty(headers, protocolHeaders.requestRole()).forEach((key, value) -> {
            SelectedRole role;
            try {
                role = SelectedRole.valueOf((String)value);
            }
            catch (IllegalArgumentException e) {
                throw HttpRequestSessionContext.badRequest(String.format("Invalid %s header", protocolHeaders.requestRole()));
            }
            roles.put(key, (Object)role);
        });
        return roles.build();
    }

    private static Map<String, String> parseExtraCredentials(ProtocolHeaders protocolHeaders, MultivaluedMap<String, String> headers) {
        return HttpRequestSessionContext.parseProperty(headers, protocolHeaders.requestExtraCredential());
    }

    private static Map<String, String> parseProperty(MultivaluedMap<String, String> headers, String headerName) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String header : HttpRequestSessionContext.splitHttpHeader(headers, headerName)) {
            List nameValue = Splitter.on((char)'=').trimResults().splitToList((CharSequence)header);
            HttpRequestSessionContext.assertRequest(nameValue.size() == 2, "Invalid %s header", headerName);
            try {
                properties.put((String)nameValue.get(0), HttpRequestSessionContext.urlDecode((String)nameValue.get(1)));
            }
            catch (IllegalArgumentException e) {
                throw HttpRequestSessionContext.badRequest(String.format("Invalid %s header: %s", headerName, e));
            }
        }
        return properties;
    }

    private static Set<String> parseClientTags(ProtocolHeaders protocolHeaders, MultivaluedMap<String, String> headers) {
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        return ImmutableSet.copyOf((Iterable)splitter.split((CharSequence)Strings.nullToEmpty((String)((String)headers.getFirst((Object)protocolHeaders.requestClientTags())))));
    }

    private static Set<String> parseClientCapabilities(ProtocolHeaders protocolHeaders, MultivaluedMap<String, String> headers) {
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        return ImmutableSet.copyOf((Iterable)splitter.split((CharSequence)Strings.nullToEmpty((String)((String)headers.getFirst((Object)protocolHeaders.requestClientCapabilities())))));
    }

    private static ResourceEstimates parseResourceEstimate(ProtocolHeaders protocolHeaders, MultivaluedMap<String, String> headers) {
        Session.ResourceEstimateBuilder builder = new Session.ResourceEstimateBuilder();
        HttpRequestSessionContext.parseProperty(headers, protocolHeaders.requestResourceEstimate()).forEach((name, value) -> {
            try {
                switch (name.toUpperCase(Locale.ENGLISH)) {
                    case "EXECUTION_TIME": {
                        builder.setExecutionTime(Duration.valueOf((String)value));
                        break;
                    }
                    case "CPU_TIME": {
                        builder.setCpuTime(Duration.valueOf((String)value));
                        break;
                    }
                    case "PEAK_MEMORY": {
                        builder.setPeakMemory(DataSize.valueOf((String)value));
                        break;
                    }
                    default: {
                        throw HttpRequestSessionContext.badRequest(String.format("Unsupported resource name %s", name));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw HttpRequestSessionContext.badRequest(String.format("Unsupported format for resource estimate '%s': %s", value, e));
            }
        });
        return builder.build();
    }

    private static void assertRequest(boolean expression, String format, Object ... args) {
        if (!expression) {
            throw HttpRequestSessionContext.badRequest(String.format(format, args));
        }
    }

    private static Map<String, String> parsePreparedStatementsHeaders(ProtocolHeaders protocolHeaders, MultivaluedMap<String, String> headers) {
        ImmutableMap.Builder preparedStatements = ImmutableMap.builder();
        HttpRequestSessionContext.parseProperty(headers, protocolHeaders.requestPreparedStatement()).forEach((key, sqlString) -> {
            String statementName;
            try {
                statementName = HttpRequestSessionContext.urlDecode(key);
            }
            catch (IllegalArgumentException e) {
                throw HttpRequestSessionContext.badRequest(String.format("Invalid %s header: %s", protocolHeaders.requestPreparedStatement(), e.getMessage()));
            }
            SqlParser sqlParser = new SqlParser();
            try {
                sqlParser.createStatement(sqlString, new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE));
            }
            catch (ParsingException e) {
                throw HttpRequestSessionContext.badRequest(String.format("Invalid %s header: %s", protocolHeaders.requestPreparedStatement(), e.getMessage()));
            }
            preparedStatements.put((Object)statementName, sqlString);
        });
        return preparedStatements.build();
    }

    private static Optional<TransactionId> parseTransactionId(String transactionId) {
        if ((transactionId = HttpRequestSessionContext.trimEmptyToNull(transactionId)) == null || transactionId.equalsIgnoreCase("none")) {
            return Optional.empty();
        }
        try {
            return Optional.of(TransactionId.valueOf(transactionId));
        }
        catch (Exception e) {
            throw HttpRequestSessionContext.badRequest(e.getMessage());
        }
    }

    private static WebApplicationException badRequest(String message) {
        throw new WebApplicationException(message, Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)message).build());
    }

    private static String trimEmptyToNull(String value) {
        return Strings.emptyToNull((String)Strings.nullToEmpty((String)value).trim());
    }

    private static String urlDecode(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }
}

