/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.validation.FileExists;
import java.util.Optional;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"internal-communication.kerberos.enabled", "internal-communication.kerberos.use-canonical-hostname", "internal-communication.jwt.enabled"})
public class InternalCommunicationConfig {
    private String sharedSecret;
    private boolean http2Enabled;
    private boolean httpsRequired;
    private String keyStorePath;
    private String keyStorePassword;
    private String trustStorePath;
    private String trustStorePassword;

    @NotNull
    public Optional<String> getSharedSecret() {
        return Optional.ofNullable(this.sharedSecret);
    }

    @ConfigSecuritySensitive
    @Config(value="internal-communication.shared-secret")
    public InternalCommunicationConfig setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
        return this;
    }

    public boolean isHttp2Enabled() {
        return this.http2Enabled;
    }

    @Config(value="internal-communication.http2.enabled")
    @ConfigDescription(value="Enable the HTTP/2 transport")
    public InternalCommunicationConfig setHttp2Enabled(boolean http2Enabled) {
        this.http2Enabled = http2Enabled;
        return this;
    }

    public boolean isHttpsRequired() {
        return this.httpsRequired;
    }

    @Config(value="internal-communication.https.required")
    public InternalCommunicationConfig setHttpsRequired(boolean httpsRequired) {
        this.httpsRequired = httpsRequired;
        return this;
    }

    @FileExists
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Config(value="internal-communication.https.keystore.path")
    public InternalCommunicationConfig setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
        return this;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Config(value="internal-communication.https.keystore.key")
    @ConfigSecuritySensitive
    public InternalCommunicationConfig setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    @FileExists
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Config(value="internal-communication.https.truststore.path")
    public InternalCommunicationConfig setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
        return this;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Config(value="internal-communication.https.truststore.key")
    @ConfigSecuritySensitive
    public InternalCommunicationConfig setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    @AssertTrue(message="Internal shared secret is required when HTTPS is enabled for internal communications")
    public @AssertTrue(message="Internal shared secret is required when HTTPS is enabled for internal communications") boolean isRequiredSharedSecretSet() {
        return !this.isHttpsRequired() || this.getSharedSecret().isPresent();
    }
}

