/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.base.Strings;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.trino.server.security.AuthenticationException;
import io.trino.server.security.Authenticator;
import io.trino.server.security.UserMapping;
import io.trino.server.security.UserMappingException;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.Identity;
import java.security.Principal;
import java.util.Objects;
import javax.ws.rs.container.ContainerRequestContext;

public abstract class AbstractBearerAuthenticator
implements Authenticator {
    private final String principalField;
    private final UserMapping userMapping;

    protected AbstractBearerAuthenticator(String principalField, UserMapping userMapping) {
        this.principalField = Objects.requireNonNull(principalField, "principalField is null");
        this.userMapping = Objects.requireNonNull(userMapping, "userMapping is null");
    }

    @Override
    public Identity authenticate(ContainerRequestContext request) throws AuthenticationException {
        String header = Strings.nullToEmpty((String)((String)request.getHeaders().getFirst((Object)"Authorization")));
        int space = header.indexOf(32);
        if (space < 0 || !header.substring(0, space).equalsIgnoreCase("bearer")) {
            throw this.needAuthentication(request, null);
        }
        String token = header.substring(space + 1).trim();
        if (token.isEmpty()) {
            throw this.needAuthentication(request, null);
        }
        try {
            Jws<Claims> claimsJws = this.parseClaimsJws(token);
            String principal = (String)((Claims)claimsJws.getBody()).get(this.principalField, String.class);
            if (principal == null) {
                throw this.needAuthentication(request, "Invalid credentials");
            }
            String authenticatedUser = this.userMapping.mapUser(principal);
            return Identity.forUser((String)authenticatedUser).withPrincipal((Principal)new BasicPrincipal(principal)).build();
        }
        catch (JwtException | UserMappingException e) {
            throw this.needAuthentication(request, e.getMessage());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Authentication error", e);
        }
    }

    protected abstract Jws<Claims> parseClaimsJws(String var1);

    protected abstract AuthenticationException needAuthentication(ContainerRequestContext var1, String var2);
}

