/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.server.InternalAuthenticationManager;
import io.trino.server.ServletSecurityUtils;
import io.trino.server.security.AuthenticationException;
import io.trino.server.security.Authenticator;
import io.trino.server.security.InsecureAuthenticator;
import io.trino.server.security.SecurityConfig;
import io.trino.spi.security.Identity;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;

@Priority(value=1000)
public class AuthenticationFilter
implements ContainerRequestFilter {
    private final List<Authenticator> authenticators;
    private final InternalAuthenticationManager internalAuthenticationManager;
    private final boolean insecureAuthenticationOverHttpAllowed;
    private final InsecureAuthenticator insecureAuthenticator;

    @Inject
    public AuthenticationFilter(List<Authenticator> authenticators, InternalAuthenticationManager internalAuthenticationManager, SecurityConfig securityConfig, InsecureAuthenticator insecureAuthenticator) {
        this.authenticators = ImmutableList.copyOf((Collection)Objects.requireNonNull(authenticators, "authenticators is null"));
        Preconditions.checkArgument((!authenticators.isEmpty() ? 1 : 0) != 0, (Object)"authenticators is empty");
        this.internalAuthenticationManager = Objects.requireNonNull(internalAuthenticationManager, "internalAuthenticationManager is null");
        this.insecureAuthenticationOverHttpAllowed = Objects.requireNonNull(securityConfig, "securityConfig is null").isInsecureAuthenticationOverHttpAllowed();
        this.insecureAuthenticator = Objects.requireNonNull(insecureAuthenticator, "insecureAuthenticator is null");
    }

    public void filter(ContainerRequestContext request) {
        ImmutableList authenticators;
        if (InternalAuthenticationManager.isInternalRequest(request)) {
            this.internalAuthenticationManager.handleInternalRequest(request);
            return;
        }
        if (request.getSecurityContext().isSecure()) {
            authenticators = this.authenticators;
        } else if (this.insecureAuthenticationOverHttpAllowed) {
            authenticators = ImmutableList.of((Object)this.insecureAuthenticator);
        } else {
            throw new ForbiddenException("Authentication over HTTP is not enabled");
        }
        LinkedHashSet<String> messages = new LinkedHashSet<String>();
        LinkedHashSet<String> authenticateHeaders = new LinkedHashSet<String>();
        for (Authenticator authenticator : authenticators) {
            Identity authenticatedIdentity;
            try {
                authenticatedIdentity = authenticator.authenticate(request);
            }
            catch (AuthenticationException e) {
                if (e.getMessage() != null) {
                    messages.add(e.getMessage());
                }
                e.getAuthenticateHeader().ifPresent(authenticateHeaders::add);
                continue;
            }
            ServletSecurityUtils.setAuthenticatedIdentity(request, authenticatedIdentity);
            return;
        }
        if (messages.isEmpty()) {
            messages.add("Unauthorized");
        }
        String error = Joiner.on((String)" | ").join(messages);
        ServletSecurityUtils.sendWwwAuthenticate(request, error, authenticateHeaders);
    }
}

