/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import io.trino.server.security.AuthenticationException;
import io.trino.server.security.Authenticator;
import io.trino.server.security.BasicAuthCredentials;
import io.trino.server.security.PasswordAuthenticatorConfig;
import io.trino.server.security.PasswordAuthenticatorManager;
import io.trino.server.security.UserMapping;
import io.trino.server.security.UserMappingException;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import java.security.Principal;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;

public class PasswordAuthenticator
implements Authenticator {
    private final PasswordAuthenticatorManager authenticatorManager;
    private final UserMapping userMapping;

    @Inject
    public PasswordAuthenticator(PasswordAuthenticatorManager authenticatorManager, PasswordAuthenticatorConfig config) {
        Objects.requireNonNull(config, "config is null");
        this.userMapping = UserMapping.createUserMapping(config.getUserMappingPattern(), config.getUserMappingFile());
        this.authenticatorManager = Objects.requireNonNull(authenticatorManager, "authenticatorManager is null");
        authenticatorManager.setRequired();
    }

    @Override
    public Identity authenticate(ContainerRequestContext request) throws AuthenticationException {
        BasicAuthCredentials basicAuthCredentials = BasicAuthCredentials.extractBasicAuthCredentials(request).orElseThrow(() -> PasswordAuthenticator.needAuthentication(null));
        try {
            Principal principal = this.authenticatorManager.getAuthenticator().createAuthenticatedPrincipal(basicAuthCredentials.getUser(), basicAuthCredentials.getPassword().orElseThrow(() -> new AuthenticationException("Malformed credentials: password is empty")));
            String authenticatedUser = this.userMapping.mapUser(principal.toString());
            return Identity.forUser((String)authenticatedUser).withPrincipal(principal).build();
        }
        catch (UserMappingException | AccessDeniedException e) {
            throw PasswordAuthenticator.needAuthentication(e.getMessage());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Authentication error", e);
        }
    }

    private static AuthenticationException needAuthentication(String message) {
        return new AuthenticationException(message, "Basic realm=\"Trino\"");
    }
}

