/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.configuration.ConfigurationAwareModule;
import io.airlift.discovery.server.DynamicAnnouncementResource;
import io.airlift.discovery.server.ServiceResource;
import io.airlift.discovery.store.StoreResource;
import io.airlift.http.server.HttpServer;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.jmx.MBeanResource;
import io.trino.server.security.AuthenticationFilter;
import io.trino.server.security.Authenticator;
import io.trino.server.security.CertificateAuthenticator;
import io.trino.server.security.CertificateAuthenticatorManager;
import io.trino.server.security.CertificateConfig;
import io.trino.server.security.InsecureAuthenticator;
import io.trino.server.security.InsecureAuthenticatorConfig;
import io.trino.server.security.KerberosAuthenticator;
import io.trino.server.security.KerberosConfig;
import io.trino.server.security.PasswordAuthenticator;
import io.trino.server.security.PasswordAuthenticatorConfig;
import io.trino.server.security.PasswordAuthenticatorManager;
import io.trino.server.security.ResourceSecurityBinder;
import io.trino.server.security.ResourceSecurityDynamicFeature;
import io.trino.server.security.SecurityConfig;
import io.trino.server.security.jwt.JwtAuthenticator;
import io.trino.server.security.jwt.JwtAuthenticatorSupportModule;
import io.trino.server.security.oauth2.OAuth2AuthenticationSupportModule;
import io.trino.server.security.oauth2.OAuth2Authenticator;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ServerSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.bind(AuthenticationFilter.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ResourceSecurityDynamicFeature.class);
        ResourceSecurityBinder.resourceSecurityBinder(binder).managementReadResource((AnnotatedElement)((Object)ServiceResource.class)).managementReadResource((AnnotatedElement)((Object)MBeanResource.class)).internalOnlyResource((AnnotatedElement)((Object)DynamicAnnouncementResource.class)).internalOnlyResource((AnnotatedElement)((Object)StoreResource.class));
        binder.bind(PasswordAuthenticatorManager.class).in(Scopes.SINGLETON);
        binder.bind(CertificateAuthenticatorManager.class).in(Scopes.SINGLETON);
        this.insecureHttpAuthenticationDefaults();
        ServerSecurityModule.authenticatorBinder(binder);
        this.install(ServerSecurityModule.authenticatorModule("certificate", CertificateAuthenticator.class, certificateBinder -> {
            OptionalBinder.newOptionalBinder((Binder)certificateBinder, HttpServer.ClientCertificate.class).setBinding().toInstance((Object)HttpServer.ClientCertificate.REQUESTED);
            ConfigBinder.configBinder((Binder)certificateBinder).bindConfig(CertificateConfig.class);
        }));
        this.installAuthenticator("kerberos", KerberosAuthenticator.class, KerberosConfig.class);
        this.installAuthenticator("password", PasswordAuthenticator.class, PasswordAuthenticatorConfig.class);
        this.install(ServerSecurityModule.authenticatorModule("jwt", JwtAuthenticator.class, (Module)new JwtAuthenticatorSupportModule()));
        this.install(ServerSecurityModule.authenticatorModule("oauth2", OAuth2Authenticator.class, (Module)new OAuth2AuthenticationSupportModule()));
        ConfigBinder.configBinder((Binder)binder).bindConfig(InsecureAuthenticatorConfig.class);
        binder.bind(InsecureAuthenticator.class).in(Scopes.SINGLETON);
        this.install(ServerSecurityModule.authenticatorModule("insecure", InsecureAuthenticator.class, unused -> {}));
    }

    @Provides
    public List<Authenticator> getAuthenticatorList(SecurityConfig config, Map<String, Authenticator> authenticators) {
        return (List)ServerSecurityModule.authenticationTypes(config).stream().map(type -> {
            Authenticator authenticator = (Authenticator)authenticators.get(type);
            if (authenticator == null) {
                throw new RuntimeException("Unknown authenticator type: " + type);
            }
            return authenticator;
        }).collect(ImmutableList.toImmutableList());
    }

    public static Module authenticatorModule(String name, Class<? extends Authenticator> clazz, Module module) {
        Preconditions.checkArgument((boolean)name.toLowerCase(Locale.ENGLISH).equals(name), (String)"name is not lower case: %s", (Object)name);
        Module authModule = binder -> ServerSecurityModule.authenticatorBinder(binder).addBinding((Object)name).to(clazz).in(Scopes.SINGLETON);
        return ConditionalModule.installModuleIf(SecurityConfig.class, config -> ServerSecurityModule.authenticationTypes(config).contains(name), (Module)ConfigurationAwareModule.combine((Module[])new Module[]{module, authModule}));
    }

    private void installAuthenticator(String name, Class<? extends Authenticator> authenticator, Class<?> config) {
        this.install(ServerSecurityModule.authenticatorModule(name, authenticator, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(config)));
    }

    private static MapBinder<String, Authenticator> authenticatorBinder(Binder binder) {
        return MapBinder.newMapBinder((Binder)binder, String.class, Authenticator.class);
    }

    private static List<String> authenticationTypes(SecurityConfig config) {
        return (List)config.getAuthenticationTypes().stream().map(type -> type.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
    }

    private void insecureHttpAuthenticationDefaults() {
        HttpServerConfig httpServerConfig = (HttpServerConfig)this.buildConfigObject(HttpServerConfig.class);
        SecurityConfig securityConfig = (SecurityConfig)this.buildConfigObject(SecurityConfig.class);
        if ((httpServerConfig.isHttpsEnabled() || httpServerConfig.isProcessForwarded()) && !securityConfig.getAuthenticationTypes().equals(ImmutableList.of((Object)"insecure"))) {
            this.install(binder -> ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(SecurityConfig.class, config -> config.setInsecureAuthenticationOverHttpAllowed(false)));
        }
    }
}

