/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import io.airlift.log.Logger;
import io.trino.server.security.ResourceSecurity;
import io.trino.server.security.oauth2.ChallengeFailedException;
import io.trino.server.security.oauth2.NonceCookie;
import io.trino.server.security.oauth2.OAuth2Service;
import io.trino.server.security.oauth2.OAuth2TokenExchange;
import io.trino.server.ui.OAuth2WebUiInstalled;
import io.trino.server.ui.OAuthWebUiCookie;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/oauth2/callback")
public class OAuth2CallbackResource {
    private static final Logger LOG = Logger.get(OAuth2CallbackResource.class);
    public static final String CALLBACK_ENDPOINT = "/oauth2/callback";
    private final OAuth2Service service;
    private final Optional<OAuth2TokenExchange> tokenExchange;
    private final boolean webUiOAuthEnabled;

    @Inject
    public OAuth2CallbackResource(OAuth2Service service, Optional<OAuth2TokenExchange> tokenExchange, Optional<OAuth2WebUiInstalled> webUiOAuthEnabled) {
        this.service = Objects.requireNonNull(service, "service is null");
        this.tokenExchange = Objects.requireNonNull(tokenExchange, "tokenExchange is null");
        this.webUiOAuthEnabled = Objects.requireNonNull(webUiOAuthEnabled, "webUiOAuthEnabled is null").isPresent();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Produces(value={"text/html"})
    public Response callback(@QueryParam(value="state") String state, @QueryParam(value="code") String code, @QueryParam(value="error") String error, @QueryParam(value="error_description") String errorDescription, @QueryParam(value="error_uri") String errorUri, @CookieParam(value="__Secure-Trino-Nonce") Cookie nonce, @Context UriInfo uriInfo) {
        OAuth2Service.OAuthResult result;
        if (error != null) {
            LOG.debug("OAuth server returned an error: error=%s, error_description=%s, error_uri=%s, state=%s", new Object[]{error, errorDescription, errorUri, state});
            return Response.ok().entity((Object)this.service.getCallbackErrorHtml(error)).build();
        }
        try {
            result = this.service.finishChallenge(state, code, uriInfo.getBaseUri().resolve(CALLBACK_ENDPOINT), NonceCookie.read(nonce));
        }
        catch (ChallengeFailedException | RuntimeException e) {
            LOG.debug((Throwable)e, "Authentication response could not be verified: state=%s", new Object[]{state});
            return Response.ok().entity((Object)this.service.getInternalFailureHtml("Authentication response could not be verified")).build();
        }
        Optional<UUID> authId = result.getAuthId();
        if (authId.isEmpty()) {
            return Response.seeOther((URI)URI.create("/ui/")).cookie(new NewCookie[]{OAuthWebUiCookie.create(result.getAccessToken(), result.getTokenExpiration()), NonceCookie.delete()}).build();
        }
        if (this.tokenExchange.isEmpty()) {
            LOG.debug("Token exchange is not active: state=%s", new Object[]{state});
            return Response.ok().entity((Object)this.service.getInternalFailureHtml("Client token exchange is not enabled")).build();
        }
        this.tokenExchange.get().setAccessToken(authId.get(), result.getAccessToken());
        Response.ResponseBuilder builder = Response.ok((Object)this.service.getSuccessHtml());
        if (this.webUiOAuthEnabled) {
            builder.cookie(new NewCookie[]{OAuthWebUiCookie.create(result.getAccessToken(), result.getTokenExpiration())});
        }
        return builder.build();
    }
}

