/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.github.scribejava.core.httpclient.multipart.MultipartPayload;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HeaderName;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.ResponseHandlerUtils;
import io.airlift.http.client.StaticBodyGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class ScribeHttpClient
implements com.github.scribejava.core.httpclient.HttpClient {
    private static final Multimap<String, String> DEFAULT_HEADERS = ImmutableMultimap.builder().put((Object)"Content-Type", (Object)"application/x-www-form-urlencoded").put((Object)"Accept", (Object)"application/json").build();
    private final HttpClient httpClient;

    public ScribeHttpClient(HttpClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, byte[] bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, MultipartPayload bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, File bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Response execute(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, byte[] bodyContents) throws InterruptedException, ExecutionException, IOException {
        return this.execute(userAgent, headers, httpVerb, completeUrl, (BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((byte[])bodyContents));
    }

    public Response execute(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, MultipartPayload bodyContents) throws InterruptedException, ExecutionException, IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Response execute(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents) throws InterruptedException, ExecutionException, IOException {
        return this.execute(userAgent, headers, httpVerb, completeUrl, (BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)bodyContents, (Charset)StandardCharsets.UTF_8));
    }

    public Response execute(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, File bodyContents) throws InterruptedException, ExecutionException, IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() throws IOException {
        this.httpClient.close();
    }

    private Response execute(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, BodyGenerator bodyGenerator) {
        ImmutableMultimap.Builder requestHeaders = ImmutableMultimap.builder().putAll(DEFAULT_HEADERS).putAll(headers.entrySet());
        if (userAgent != null) {
            requestHeaders.put((Object)"User-Agent", (Object)userAgent);
        }
        Request request = Request.builder().setMethod(httpVerb.name()).setUri(URI.create(completeUrl)).setBodyGenerator(bodyGenerator).addHeaders((Multimap)requestHeaders.build()).build();
        return (Response)this.httpClient.execute(request, (ResponseHandler)new ConvertingResponseHandler());
    }

    private static class ConvertingResponseHandler
    implements ResponseHandler<Response, RuntimeException> {
        private ConvertingResponseHandler() {
        }

        public Response handleException(Request request, Exception exception) {
            throw ResponseHandlerUtils.propagate((Request)request, (Throwable)exception);
        }

        public Response handle(Request request, io.airlift.http.client.Response response) {
            return ConvertingResponseHandler.convertResponse(response);
        }

        private static Response convertResponse(io.airlift.http.client.Response response) {
            int code = response.getStatusCode();
            Map headers = (Map)response.getHeaders().asMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> ((HeaderName)e.getKey()).toString(), e -> String.join((CharSequence)",", (Iterable)e.getValue())));
            try {
                return new Response(code, HttpStatus.fromStatusCode((int)code).toString(), headers, new String(ByteStreams.toByteArray((InputStream)response.getInputStream()), StandardCharsets.UTF_8));
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
    }
}

