/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.ConfigBinder;
import io.airlift.jaxrs.JaxrsBinder;
import io.trino.server.security.Authenticator;
import io.trino.server.security.PasswordAuthenticatorManager;
import io.trino.server.ui.ForWebUi;
import io.trino.server.ui.FormAuthenticator;
import io.trino.server.ui.FormWebUiAuthenticationFilter;
import io.trino.server.ui.FormWebUiConfig;
import io.trino.server.ui.InsecureFormAuthenticator;
import io.trino.server.ui.LoginResource;
import io.trino.server.ui.PasswordManagerFormAuthenticator;
import io.trino.server.ui.WebUiAuthenticationFilter;

public class FormUiAuthenticatorModule
implements Module {
    private final boolean usePasswordManager;

    public FormUiAuthenticatorModule(boolean usePasswordManager) {
        this.usePasswordManager = usePasswordManager;
    }

    public void configure(Binder binder) {
        binder.bind(PasswordAuthenticatorManager.class).in(Scopes.SINGLETON);
        binder.bind(FormWebUiAuthenticationFilter.class).in(Scopes.SINGLETON);
        binder.bind(WebUiAuthenticationFilter.class).to(FormWebUiAuthenticationFilter.class).in(Scopes.SINGLETON);
        if (this.usePasswordManager) {
            binder.bind(FormAuthenticator.class).to(PasswordManagerFormAuthenticator.class).in(Scopes.SINGLETON);
        } else {
            binder.bind(FormAuthenticator.class).to(InsecureFormAuthenticator.class).in(Scopes.SINGLETON);
        }
        ConfigBinder.configBinder((Binder)binder).bindConfig(FormWebUiConfig.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(LoginResource.class);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Authenticator.class, ForWebUi.class));
    }
}

