/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.cost.StatsCalculator;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.security.GroupProvider;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.CorrelationSupport;
import io.trino.sql.analyzer.ExpressionTreeUtils;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.StatementAnalyzer;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.rewrite.StatementRewrite;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GroupingOperation;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class Analyzer {
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final AccessControl accessControl;
    private final GroupProvider groupProvider;
    private final Session session;
    private final Optional<QueryExplainer> queryExplainer;
    private final List<Expression> parameters;
    private final Map<NodeRef<Parameter>, Expression> parameterLookup;
    private final WarningCollector warningCollector;
    private final StatsCalculator statsCalculator;

    public Analyzer(Session session, Metadata metadata, SqlParser sqlParser, GroupProvider groupProvider, AccessControl accessControl, Optional<QueryExplainer> queryExplainer, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, WarningCollector warningCollector, StatsCalculator statsCalculator) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.groupProvider = Objects.requireNonNull(groupProvider, "groupProvider is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.queryExplainer = Objects.requireNonNull(queryExplainer, "query explainer is null");
        this.parameters = parameters;
        this.parameterLookup = parameterLookup;
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
    }

    public Analysis analyze(Statement statement) {
        return this.analyze(statement, false);
    }

    public Analysis analyze(Statement statement, boolean isDescribe) {
        Statement rewrittenStatement = StatementRewrite.rewrite(this.session, this.metadata, this.sqlParser, this.queryExplainer, statement, this.parameters, this.parameterLookup, this.groupProvider, this.accessControl, this.warningCollector, this.statsCalculator);
        Analysis analysis = new Analysis(rewrittenStatement, this.parameterLookup, isDescribe);
        StatementAnalyzer analyzer = new StatementAnalyzer(analysis, this.metadata, this.sqlParser, this.groupProvider, this.accessControl, this.session, this.warningCollector, CorrelationSupport.ALLOWED);
        analyzer.analyze((Node)rewrittenStatement, Optional.empty());
        analysis.getTableColumnReferences().forEach((accessControlInfo, tableColumnReferences) -> tableColumnReferences.forEach((tableName, columns) -> accessControlInfo.getAccessControl().checkCanSelectFromColumns(accessControlInfo.getSecurityContext(this.session.getRequiredTransactionId(), this.session.getQueryId()), (QualifiedObjectName)tableName, (Set<String>)columns)));
        return analysis;
    }

    static void verifyNoAggregateWindowOrGroupingFunctions(Metadata metadata, Expression predicate, String clause) {
        List<GroupingOperation> groupingOperations;
        List<FunctionCall> windowExpressions;
        List<FunctionCall> aggregates = ExpressionTreeUtils.extractAggregateFunctions((Iterable<? extends Node>)ImmutableList.of((Object)predicate), metadata);
        ImmutableList found = ImmutableList.copyOf((Iterable)Iterables.concat(aggregates, windowExpressions = ExpressionTreeUtils.extractWindowFunctions((Iterable<? extends Node>)ImmutableList.of((Object)predicate)), groupingOperations = ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)predicate), GroupingOperation.class)));
        if (!found.isEmpty()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_SCALAR, (Node)predicate, "%s cannot contain aggregations, window functions or grouping operations: %s", clause, found);
        }
    }
}

