/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.InstructionNode;
import io.airlift.bytecode.instruction.LabelNode;
import io.airlift.bytecode.instruction.VariableInstruction;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.Type;
import io.trino.sql.gen.BytecodeGenerator;
import io.trino.sql.gen.BytecodeGeneratorContext;
import io.trino.sql.gen.BytecodeUtils;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SwitchCodeGenerator
implements BytecodeGenerator {
    private final Type returnType;
    private final RowExpression value;
    private final List<SpecialForm> whenClauses;
    private final Optional<RowExpression> elseValue;
    private final List<ResolvedFunction> equalsFunctions;

    public SwitchCodeGenerator(SpecialForm specialForm) {
        Objects.requireNonNull(specialForm, "specialForm is null");
        this.returnType = specialForm.getType();
        List<RowExpression> arguments = specialForm.getArguments();
        this.value = arguments.get(0);
        RowExpression last = arguments.get(arguments.size() - 1);
        if (last instanceof SpecialForm && ((SpecialForm)last).getForm() == SpecialForm.Form.WHEN) {
            this.whenClauses = (List)arguments.subList(1, arguments.size()).stream().map(SpecialForm.class::cast).collect(ImmutableList.toImmutableList());
            this.elseValue = Optional.empty();
        } else {
            this.whenClauses = (List)arguments.subList(1, arguments.size() - 1).stream().map(SpecialForm.class::cast).collect(ImmutableList.toImmutableList());
            this.elseValue = Optional.of(last);
        }
        Preconditions.checkArgument((boolean)this.whenClauses.stream().map(SpecialForm::getForm).allMatch(SpecialForm.Form.WHEN::equals));
        this.equalsFunctions = ImmutableList.copyOf(specialForm.getFunctionDependencies());
        Preconditions.checkArgument((this.equalsFunctions.size() == this.whenClauses.size() ? 1 : 0) != 0);
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generatorContext) {
        Scope scope = generatorContext.getScope();
        BytecodeNode valueBytecode = generatorContext.generate(this.value);
        Object elseValue = !this.elseValue.isPresent() ? new BytecodeBlock().append((BytecodeNode)generatorContext.wasNull().set(BytecodeExpressions.constantTrue())).pushJavaDefault(this.returnType.getJavaType()) : generatorContext.generate(this.elseValue.get());
        Class valueType = this.value.getType().getJavaType();
        LabelNode nullValue = new LabelNode("nullCondition");
        Variable tempVariable = scope.createTempVariable(valueType);
        BytecodeBlock block = new BytecodeBlock().append(valueBytecode).append(BytecodeUtils.ifWasNullClearPopAndGoto(scope, nullValue, Void.TYPE, valueType)).putVariable(tempVariable);
        InstructionNode getTempVariableNode = VariableInstruction.loadVariable((Variable)tempVariable);
        elseValue = new BytecodeBlock().visitLabel(nullValue).append(elseValue);
        for (int i = this.whenClauses.size() - 1; i >= 0; --i) {
            SpecialForm clause = this.whenClauses.get(i);
            RowExpression operand = clause.getArguments().get(0);
            RowExpression result = clause.getArguments().get(1);
            BytecodeNode equalsCall = generatorContext.generateCall(this.equalsFunctions.get(i), (List<BytecodeNode>)ImmutableList.of((Object)generatorContext.generate(operand), (Object)getTempVariableNode));
            BytecodeBlock condition = new BytecodeBlock().append(equalsCall).append((BytecodeNode)generatorContext.wasNull().set(BytecodeExpressions.constantFalse()));
            elseValue = new IfStatement("when", new Object[0]).condition((BytecodeNode)condition).ifTrue(generatorContext.generate(result)).ifFalse(elseValue);
        }
        return block.append(elseValue);
    }
}

