/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.spi.type.Type;
import io.trino.sql.planner.FunctionCallBuilder;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.tree.TryExpression;
import io.trino.type.FunctionType;
import java.util.List;
import java.util.Map;

public final class DesugarTryExpressionRewriter {
    private DesugarTryExpressionRewriter() {
    }

    public static Expression rewrite(Expression expression, Metadata metadata, TypeAnalyzer typeAnalyzer, Session session, SymbolAllocator symbolAllocator) {
        if (expression instanceof SymbolReference) {
            return expression;
        }
        Map<NodeRef<Expression>, Type> expressionTypes = typeAnalyzer.getTypes(session, symbolAllocator.getTypes(), expression);
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(metadata, expressionTypes), (Expression)expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Metadata metadata;
        private final Map<NodeRef<Expression>, Type> expressionTypes;

        public Visitor(Metadata metadata, Map<NodeRef<Expression>, Type> expressionTypes) {
            this.metadata = metadata;
            this.expressionTypes = expressionTypes;
        }

        public Expression rewriteTryExpression(TryExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Type type = this.expressionTypes.get(NodeRef.of((Node)node));
            Expression expression = treeRewriter.rewrite(node.getInnerExpression(), (Object)context);
            return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"$internal$try")).addArgument(new FunctionType((List<Type>)ImmutableList.of(), type), (Expression)new LambdaExpression((List)ImmutableList.of(), expression)).build();
        }
    }
}

