/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.Metadata;
import io.trino.sql.tree.DefaultExpressionTraversalVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Node;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public final class DeterminismEvaluator {
    private DeterminismEvaluator() {
    }

    public static boolean isDeterministic(Expression expression, Metadata metadata) {
        return DeterminismEvaluator.isDeterministic(expression, (FunctionCall functionCall) -> metadata.getFunctionMetadata(metadata.decodeFunction(functionCall.getName())));
    }

    public static boolean isDeterministic(Expression expression, Function<FunctionCall, FunctionMetadata> functionMetadataSupplier) {
        Objects.requireNonNull(functionMetadataSupplier, "functionMetadataSupplier is null");
        Objects.requireNonNull(expression, "expression is null");
        AtomicBoolean deterministic = new AtomicBoolean(true);
        new Visitor(functionMetadataSupplier).process((Node)expression, deterministic);
        return deterministic.get();
    }

    private static class Visitor
    extends DefaultExpressionTraversalVisitor<AtomicBoolean> {
        private final Function<FunctionCall, FunctionMetadata> functionMetadataSupplier;

        public Visitor(Function<FunctionCall, FunctionMetadata> functionMetadataSupplier) {
            this.functionMetadataSupplier = functionMetadataSupplier;
        }

        protected Void visitFunctionCall(FunctionCall node, AtomicBoolean deterministic) {
            if (!this.functionMetadataSupplier.apply(node).isDeterministic()) {
                deterministic.set(false);
            }
            return super.visitFunctionCall(node, (Object)deterministic);
        }
    }
}

