/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import java.util.Map;
import java.util.Objects;

public class ParameterRewriter
extends ExpressionRewriter<Void> {
    private final Map<NodeRef<Parameter>, Expression> parameters;
    private final Analysis analysis;

    public ParameterRewriter(Map<NodeRef<Parameter>, Expression> parameters) {
        Objects.requireNonNull(parameters, "parameterMap is null");
        this.parameters = parameters;
        this.analysis = null;
    }

    public ParameterRewriter(Analysis analysis) {
        this.analysis = analysis;
        this.parameters = analysis.getParameters();
    }

    protected Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
        return treeRewriter.defaultRewrite(node, (Object)context);
    }

    public Expression rewriteParameter(Parameter node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
        Preconditions.checkState((this.parameters.size() > node.getPosition() ? 1 : 0) != 0, (Object)"Too few parameter values");
        return this.coerceIfNecessary((Expression)node, this.parameters.get(NodeRef.of((Node)node)));
    }

    private Expression coerceIfNecessary(Expression original, Expression rewritten) {
        if (this.analysis == null) {
            return rewritten;
        }
        Type coercion = this.analysis.getCoercion(original);
        if (coercion != null) {
            rewritten = new Cast(rewritten, TypeSignatureTranslator.toSqlType(coercion), false, this.analysis.isTypeOnlyCoercion(original));
        }
        return rewritten;
    }
}

