/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.analyzer.RelationType;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TranslationMap;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class RelationPlan {
    private final PlanNode root;
    private final List<Symbol> fieldMappings;
    private final Scope scope;
    private final Optional<TranslationMap> outerContext;

    public RelationPlan(PlanNode root, Scope scope, List<Symbol> fieldMappings, Optional<TranslationMap> outerContext) {
        Objects.requireNonNull(root, "root is null");
        Objects.requireNonNull(fieldMappings, "outputSymbols is null");
        Objects.requireNonNull(scope, "scope is null");
        Objects.requireNonNull(outerContext, "outerContext is null");
        int allFieldCount = scope.getLocalScopeFieldCount();
        Preconditions.checkArgument((allFieldCount == fieldMappings.size() ? 1 : 0) != 0, (String)"Number of outputs (%s) doesn't match number of fields in local scope (%s)", (int)fieldMappings.size(), (int)allFieldCount);
        this.root = root;
        this.scope = scope;
        this.fieldMappings = ImmutableList.copyOf(fieldMappings);
        this.outerContext = outerContext;
    }

    public Symbol getSymbol(int fieldIndex) {
        Preconditions.checkArgument((fieldIndex >= 0 && fieldIndex < this.fieldMappings.size() ? 1 : 0) != 0, (String)"No field->symbol mapping for field %s", (int)fieldIndex);
        return this.fieldMappings.get(fieldIndex);
    }

    public PlanNode getRoot() {
        return this.root;
    }

    public List<Symbol> getFieldMappings() {
        return this.fieldMappings;
    }

    public RelationType getDescriptor() {
        return this.scope.getRelationType();
    }

    public Scope getScope() {
        return this.scope;
    }

    public Optional<TranslationMap> getOuterContext() {
        return this.outerContext;
    }
}

