/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.tree.DefaultExpressionTraversalVisitor;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SymbolReference;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class DereferencePushdown {
    private DereferencePushdown() {
    }

    public static Set<DereferenceExpression> extractDereferences(Collection<Expression> expressions, boolean allowOverlap) {
        Set symbolReferencesAndDereferences;
        Set candidateExpressions = symbolReferencesAndDereferences = expressions.stream().flatMap(expression -> DereferencePushdown.getSymbolReferencesAndDereferences(expression).stream()).collect(Collectors.toSet());
        if (!allowOverlap) {
            candidateExpressions = symbolReferencesAndDereferences.stream().filter(expression -> !DereferencePushdown.prefixExists(expression, symbolReferencesAndDereferences)).collect(Collectors.toSet());
        }
        return candidateExpressions.stream().filter(DereferenceExpression.class::isInstance).map(DereferenceExpression.class::cast).collect(Collectors.toSet());
    }

    public static boolean exclusiveDereferences(Set<Expression> projections) {
        return projections.stream().allMatch(expression -> expression instanceof SymbolReference || expression instanceof DereferenceExpression && DereferencePushdown.isDereferenceChain((DereferenceExpression)expression) && !DereferencePushdown.prefixExists(expression, projections));
    }

    public static Symbol getBase(DereferenceExpression expression) {
        return (Symbol)Iterables.getOnlyElement(SymbolsExtractor.extractAll((Expression)expression));
    }

    private static List<Expression> getSymbolReferencesAndDereferences(Expression expression) {
        ImmutableList.Builder builder = ImmutableList.builder();
        new DefaultExpressionTraversalVisitor<ImmutableList.Builder<Expression>>(){

            protected Void visitDereferenceExpression(DereferenceExpression node, ImmutableList.Builder<Expression> context) {
                if (DereferencePushdown.isDereferenceChain(node)) {
                    context.add((Object)node);
                }
                return null;
            }

            protected Void visitSymbolReference(SymbolReference node, ImmutableList.Builder<Expression> context) {
                context.add((Object)node);
                return null;
            }

            protected Void visitLambdaExpression(LambdaExpression node, ImmutableList.Builder<Expression> context) {
                return null;
            }
        }.process((Node)expression, (Object)builder);
        return builder.build();
    }

    private static boolean isDereferenceChain(DereferenceExpression expression) {
        return expression.getBase() instanceof SymbolReference || expression.getBase() instanceof DereferenceExpression && DereferencePushdown.isDereferenceChain((DereferenceExpression)expression.getBase());
    }

    private static boolean prefixExists(Expression expression, Set<Expression> expressions) {
        Expression current = expression;
        while (current instanceof DereferenceExpression) {
            if (!expressions.contains(current = ((DereferenceExpression)current).getBase())) continue;
            return true;
        }
        Verify.verify((boolean)(current instanceof SymbolReference));
        return false;
    }
}

