/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.WindowFrame;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ImplementLimitWithTies
implements Rule<LimitNode> {
    private static final Capture<PlanNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().matching(LimitNode::isWithTies).with(Patterns.source().capturedAs(CHILD));
    private final Metadata metadata;

    public ImplementLimitWithTies(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        PlanNode child = (PlanNode)captures.get(CHILD);
        Symbol rankSymbol = context.getSymbolAllocator().newSymbol("rank_num", (Type)BigintType.BIGINT);
        ResolvedFunction function = this.metadata.resolveFunction(QualifiedName.of((String)"rank"), (List<TypeSignatureProvider>)ImmutableList.of());
        WindowNode.Frame frame = new WindowNode.Frame(WindowFrame.Type.RANGE, FrameBound.Type.UNBOUNDED_PRECEDING, Optional.empty(), Optional.empty(), FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        WindowNode.Function rankFunction = new WindowNode.Function(function, (List<Expression>)ImmutableList.of(), frame, false);
        WindowNode windowNode = new WindowNode(context.getIdAllocator().getNextId(), child, new WindowNode.Specification((List<Symbol>)ImmutableList.of(), parent.getTiesResolvingScheme()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rankSymbol, (Object)rankFunction), Optional.empty(), (Set<Symbol>)ImmutableSet.of(), 0);
        FilterNode filterNode = new FilterNode(context.getIdAllocator().getNextId(), windowNode, (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)rankSymbol.toSymbolReference(), (Expression)new GenericLiteral("BIGINT", Long.toString(parent.getCount()))));
        ProjectNode projectNode = new ProjectNode(context.getIdAllocator().getNextId(), filterNode, Assignments.identity(parent.getOutputSymbols()));
        return Rule.Result.ofPlanNode(projectNode);
    }
}

