/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.ExpressionSymbolInliner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.TryExpression;
import io.trino.sql.util.AstUtils;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InlineProjections
implements Rule<ProjectNode> {
    private static final Capture<ProjectNode> CHILD = Capture.newCapture();
    private static final Pattern<ProjectNode> PATTERN = Patterns.project().with(Patterns.source().matching(Patterns.project().capturedAs(CHILD)));

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ProjectNode parent, Captures captures, Rule.Context context) {
        ProjectNode child = (ProjectNode)captures.get(CHILD);
        return InlineProjections.inlineProjections(parent, child).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }

    static Optional<ProjectNode> inlineProjections(ProjectNode parent, ProjectNode child) {
        Set<Symbol> targets = InlineProjections.extractInliningTargets(parent, child);
        if (targets.isEmpty()) {
            return Optional.empty();
        }
        Assignments assignments = child.getAssignments().filter(targets::contains);
        Map<Symbol, Expression> parentAssignments = parent.getAssignments().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> InlineProjections.inlineReferences((Expression)entry.getValue(), assignments)));
        Set inputs = child.getAssignments().entrySet().stream().filter(entry -> targets.contains(entry.getKey())).map(Map.Entry::getValue).flatMap(entry -> SymbolsExtractor.extractAll(entry).stream()).collect(Collectors.toSet());
        Assignments.Builder newChildAssignmentsBuilder = Assignments.builder();
        for (Map.Entry<Symbol, Expression> assignment : child.getAssignments().entrySet()) {
            if (targets.contains(assignment.getKey())) continue;
            newChildAssignmentsBuilder.put(assignment);
        }
        for (Symbol input : inputs) {
            newChildAssignmentsBuilder.putIdentity(input);
        }
        Assignments newChildAssignments = newChildAssignmentsBuilder.build();
        PlanNode newChild = newChildAssignments.isIdentity() ? child.getSource() : new ProjectNode(child.getId(), child.getSource(), newChildAssignments);
        return Optional.of(new ProjectNode(parent.getId(), newChild, Assignments.copyOf(parentAssignments)));
    }

    private static Expression inlineReferences(Expression expression, Assignments assignments) {
        Function<Symbol, Expression> mapping = symbol -> {
            Expression result = assignments.get((Symbol)symbol);
            if (result != null) {
                return result;
            }
            return symbol.toSymbolReference();
        };
        return ExpressionSymbolInliner.inlineSymbols(mapping, expression);
    }

    private static Set<Symbol> extractInliningTargets(ProjectNode parent, ProjectNode child) {
        ImmutableSet childOutputSet = ImmutableSet.copyOf(child.getOutputSymbols());
        Map dependencies = parent.getAssignments().getExpressions().stream().flatMap(expression -> SymbolsExtractor.extractAll(expression).stream()).filter(((Set)childOutputSet)::contains).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Set constants = dependencies.keySet().stream().filter(input -> child.getAssignments().get((Symbol)input) instanceof Literal).collect(Collectors.toSet());
        Set tryArguments = parent.getAssignments().getExpressions().stream().flatMap(expression -> InlineProjections.extractTryArguments(expression).stream()).collect(Collectors.toSet());
        Set singletons = dependencies.entrySet().stream().filter(entry -> (Long)entry.getValue() == 1L).filter(entry -> !tryArguments.contains(entry.getKey())).filter(entry -> !child.getAssignments().isIdentity((Symbol)entry.getKey())).filter(entry -> !(child.getAssignments().get((Symbol)entry.getKey()) instanceof DereferenceExpression)).map(Map.Entry::getKey).collect(Collectors.toSet());
        return Sets.union(singletons, constants);
    }

    private static Set<Symbol> extractTryArguments(Expression expression) {
        return AstUtils.preOrder((Node)expression).filter(TryExpression.class::isInstance).map(TryExpression.class::cast).flatMap(tryExpression -> SymbolsExtractor.extractAll((Expression)tryExpression).stream()).collect(Collectors.toSet());
    }
}

