/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.OffsetNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;

public class PushLimitThroughOffset
implements Rule<LimitNode> {
    private static final Capture<OffsetNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.offset().capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        long count;
        OffsetNode child = (OffsetNode)captures.get(CHILD);
        try {
            count = Math.addExact(parent.getCount(), child.getCount());
        }
        catch (ArithmeticException e) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(child.replaceChildren((List<PlanNode>)ImmutableList.of((Object)new LimitNode(parent.getId(), child.getSource(), count, parent.getTiesResolvingScheme(), parent.isPartial()))));
    }
}

