/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DereferencePushdown;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.optimizations.SymbolMapper;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SymbolReference;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class PushLimitThroughProject
implements Rule<LimitNode> {
    private static final Capture<ProjectNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.project().matching(projectNode -> !projectNode.isIdentity()).capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        ProjectNode projectNode = (ProjectNode)captures.get(CHILD);
        ImmutableSet projections = ImmutableSet.copyOf(projectNode.getAssignments().getExpressions());
        if (!DereferencePushdown.extractDereferences((Collection<Expression>)projections, false).isEmpty() && DereferencePushdown.exclusiveDereferences((Set<Expression>)projections)) {
            return Rule.Result.empty();
        }
        if (!parent.isWithTies()) {
            return Rule.Result.ofPlanNode(Util.transpose(parent, projectNode));
        }
        SymbolMapper.Builder symbolMapper = SymbolMapper.builder();
        for (Symbol symbol : parent.getTiesResolvingScheme().get().getOrderBy()) {
            Expression expression = projectNode.getAssignments().get(symbol);
            if (!(expression instanceof SymbolReference)) {
                return Rule.Result.empty();
            }
            symbolMapper.put(symbol, Symbol.from(expression));
        }
        LimitNode mappedLimitNode = symbolMapper.build().map(parent, projectNode.getSource());
        return Rule.Result.ofPlanNode(projectNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)mappedLimitNode)));
    }
}

