/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.SemiJoinNode;

public class PushLimitThroughSemiJoin
implements Rule<LimitNode> {
    private static final Capture<SemiJoinNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.semiJoin().capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        SemiJoinNode semiJoinNode = (SemiJoinNode)captures.get(CHILD);
        if (parent.isWithTies() && parent.getTiesResolvingScheme().get().getOrderBy().contains(semiJoinNode.getSemiJoinOutput())) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(Util.transpose(parent, semiJoinNode));
    }
}

