/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.ChildReplacer;
import io.trino.sql.planner.plan.DeleteNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SimplePlanRewriter;
import io.trino.sql.planner.plan.StatisticsWriterNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.UpdateNode;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class BeginTableWrite
implements PlanOptimizer {
    private final Metadata metadata;

    public BeginTableWrite(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        return SimplePlanRewriter.rewriteWith(new Rewriter(session), plan, new Context());
    }

    public static class Context {
        private Optional<TableWriterNode.WriterTarget> handle = Optional.empty();
        private Optional<TableWriterNode.WriterTarget> materializedHandle = Optional.empty();

        public void addMaterializedHandle(TableWriterNode.WriterTarget handle, TableWriterNode.WriterTarget materializedHandle) {
            Preconditions.checkState((boolean)this.handle.isEmpty(), (Object)"can only have one WriterTarget in a subtree");
            this.handle = Optional.of(handle);
            this.materializedHandle = Optional.of(materializedHandle);
        }

        public Optional<TableWriterNode.WriterTarget> getMaterializedHandle(TableWriterNode.WriterTarget handle) {
            Preconditions.checkState((boolean)this.handle.get().equals(handle), (Object)"can't find materialized handle for WriterTarget");
            return this.materializedHandle;
        }
    }

    private class Rewriter
    extends SimplePlanRewriter<Context> {
        private final Session session;

        public Rewriter(Session session) {
            this.session = session;
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            TableWriterNode.WriterTarget writerTarget = context.get().getMaterializedHandle(node.getTarget()).get();
            return new TableWriterNode(node.getId(), node.getSource().accept(this, context), writerTarget, node.getRowCountSymbol(), node.getFragmentSymbol(), node.getColumns(), node.getColumnNames(), node.getNotNullColumnSymbols(), node.getPartitioningScheme(), node.getStatisticsAggregation(), node.getStatisticsAggregationDescriptor());
        }

        @Override
        public PlanNode visitDelete(DeleteNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            TableWriterNode.DeleteTarget deleteTarget = (TableWriterNode.DeleteTarget)context.get().getMaterializedHandle(node.getTarget()).get();
            return new DeleteNode(node.getId(), this.rewriteModifyTableScan(node.getSource(), deleteTarget.getHandle()), deleteTarget, node.getRowId(), node.getOutputSymbols());
        }

        @Override
        public PlanNode visitUpdate(UpdateNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            TableWriterNode.UpdateTarget updateTarget = (TableWriterNode.UpdateTarget)context.get().getMaterializedHandle(node.getTarget()).get();
            return new UpdateNode(node.getId(), this.rewriteModifyTableScan(node.getSource(), updateTarget.getHandle()), updateTarget, node.getRowId(), node.getColumnValueAndRowIdSymbols(), node.getOutputSymbols());
        }

        @Override
        public PlanNode visitStatisticsWriterNode(StatisticsWriterNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            PlanNode child = node.getSource();
            child = child.accept(this, context);
            StatisticsWriterNode.WriteStatisticsHandle analyzeHandle = new StatisticsWriterNode.WriteStatisticsHandle(BeginTableWrite.this.metadata.beginStatisticsCollection(this.session, ((StatisticsWriterNode.WriteStatisticsReference)node.getTarget()).getHandle()));
            return new StatisticsWriterNode(node.getId(), child, analyzeHandle, node.getRowCountSymbol(), node.isRowCountEnabled(), node.getDescriptor());
        }

        @Override
        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            PlanNode child = node.getSource();
            TableWriterNode.WriterTarget originalTarget = this.getTarget(child);
            TableWriterNode.WriterTarget newTarget = this.createWriterTarget(originalTarget);
            context.get().addMaterializedHandle(originalTarget, newTarget);
            child = child.accept(this, context);
            return new TableFinishNode(node.getId(), child, newTarget, node.getRowCountSymbol(), node.getStatisticsAggregation(), node.getStatisticsAggregationDescriptor());
        }

        public TableWriterNode.WriterTarget getTarget(PlanNode node) {
            if (node instanceof TableWriterNode) {
                return ((TableWriterNode)node).getTarget();
            }
            if (node instanceof DeleteNode) {
                return ((DeleteNode)node).getTarget();
            }
            if (node instanceof UpdateNode) {
                return ((UpdateNode)node).getTarget();
            }
            if (node instanceof ExchangeNode || node instanceof UnionNode) {
                Set writerTargets = node.getSources().stream().map(this::getTarget).collect(Collectors.toSet());
                return (TableWriterNode.WriterTarget)Iterables.getOnlyElement(writerTargets);
            }
            throw new IllegalArgumentException("Invalid child for TableCommitNode: " + node.getClass().getSimpleName());
        }

        private TableWriterNode.WriterTarget createWriterTarget(TableWriterNode.WriterTarget target) {
            if (target instanceof TableWriterNode.CreateReference) {
                TableWriterNode.CreateReference create = (TableWriterNode.CreateReference)target;
                return new TableWriterNode.CreateTarget(BeginTableWrite.this.metadata.beginCreateTable(this.session, create.getCatalog(), create.getTableMetadata(), create.getLayout()), create.getTableMetadata().getTable());
            }
            if (target instanceof TableWriterNode.InsertReference) {
                TableWriterNode.InsertReference insert = (TableWriterNode.InsertReference)target;
                return new TableWriterNode.InsertTarget(BeginTableWrite.this.metadata.beginInsert(this.session, insert.getHandle(), insert.getColumns()), BeginTableWrite.this.metadata.getTableMetadata(this.session, insert.getHandle()).getTable());
            }
            if (target instanceof TableWriterNode.DeleteTarget) {
                TableWriterNode.DeleteTarget delete = (TableWriterNode.DeleteTarget)target;
                return new TableWriterNode.DeleteTarget(BeginTableWrite.this.metadata.beginDelete(this.session, delete.getHandle()), delete.getSchemaTableName());
            }
            if (target instanceof TableWriterNode.UpdateTarget) {
                TableWriterNode.UpdateTarget update = (TableWriterNode.UpdateTarget)target;
                return new TableWriterNode.UpdateTarget(BeginTableWrite.this.metadata.beginUpdate(this.session, update.getHandle(), (List<ColumnHandle>)ImmutableList.copyOf(update.getUpdatedColumnHandles())), update.getSchemaTableName(), update.getUpdatedColumns(), update.getUpdatedColumnHandles());
            }
            if (target instanceof TableWriterNode.RefreshMaterializedViewReference) {
                TableWriterNode.RefreshMaterializedViewReference refreshMV = (TableWriterNode.RefreshMaterializedViewReference)target;
                return new TableWriterNode.RefreshMaterializedViewTarget(refreshMV.getStorageTableHandle(), BeginTableWrite.this.metadata.beginRefreshMaterializedView(this.session, refreshMV.getStorageTableHandle(), refreshMV.getSourceTableHandles()), BeginTableWrite.this.metadata.getTableMetadata(this.session, refreshMV.getStorageTableHandle()).getTable(), refreshMV.getSourceTableHandles());
            }
            throw new IllegalArgumentException("Unhandled target type: " + target.getClass().getSimpleName());
        }

        private PlanNode rewriteModifyTableScan(PlanNode node, TableHandle handle) {
            JoinNode joinNode;
            if (node instanceof TableScanNode) {
                TableScanNode scan = (TableScanNode)node;
                return new TableScanNode(scan.getId(), handle, scan.getOutputSymbols(), scan.getAssignments(), scan.getEnforcedConstraint(), scan.isForDelete());
            }
            if (node instanceof FilterNode) {
                PlanNode source = this.rewriteModifyTableScan(((FilterNode)node).getSource(), handle);
                return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source));
            }
            if (node instanceof ProjectNode) {
                PlanNode source = this.rewriteModifyTableScan(((ProjectNode)node).getSource(), handle);
                return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source));
            }
            if (node instanceof SemiJoinNode) {
                PlanNode source = this.rewriteModifyTableScan(((SemiJoinNode)node).getSource(), handle);
                return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source, (Object)((SemiJoinNode)node).getFilteringSource()));
            }
            if (node instanceof JoinNode && (joinNode = (JoinNode)node).getType() == JoinNode.Type.INNER && QueryCardinalityUtil.isAtMostScalar(joinNode.getRight())) {
                PlanNode source = this.rewriteModifyTableScan(joinNode.getLeft(), handle);
                return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source, (Object)joinNode.getRight()));
            }
            throw new IllegalArgumentException("Invalid descendant for DeleteNode or UpdateNode: " + node.getClass().getName());
        }
    }
}

