/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.trino.Session;
import io.trino.cost.PlanCostEstimate;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsAndCosts;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableMetadata;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Marker;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.planner.DomainTranslator;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.planprinter.ValuePrinter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class IoPlanPrinter {
    private final Plan plan;
    private final Metadata metadata;
    private final TypeOperators typeOperators;
    private final Session session;
    private final ValuePrinter valuePrinter;

    private IoPlanPrinter(Plan plan, Metadata metadata, TypeOperators typeOperators, Session session) {
        this.plan = Objects.requireNonNull(plan, "plan is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.valuePrinter = new ValuePrinter(metadata, session);
    }

    public static String textIoPlan(Plan plan, Metadata metadata, TypeOperators typeOperators, Session session) {
        return new IoPlanPrinter(plan, metadata, typeOperators, session).print();
    }

    private String print() {
        IoPlan.IoPlanBuilder ioPlanBuilder = new IoPlan.IoPlanBuilder(this.plan);
        this.plan.getRoot().accept(new IoPlanVisitor(), ioPlanBuilder);
        return JsonCodec.jsonCodec(IoPlan.class).toJson((Object)ioPlanBuilder.build());
    }

    private class IoPlanVisitor
    extends PlanVisitor<Void, IoPlan.IoPlanBuilder> {
        private IoPlanVisitor() {
        }

        @Override
        protected Void visitPlan(PlanNode node, IoPlan.IoPlanBuilder context) {
            return this.processChildren(node, context);
        }

        @Override
        public Void visitFilter(FilterNode node, IoPlan.IoPlanBuilder context) {
            PlanNode source = node.getSource();
            if (source instanceof TableScanNode) {
                TableScanNode tableScanNode = (TableScanNode)source;
                DomainTranslator.ExtractionResult decomposedPredicate = DomainTranslator.fromPredicate(IoPlanPrinter.this.metadata, IoPlanPrinter.this.typeOperators, IoPlanPrinter.this.session, node.getPredicate(), IoPlanPrinter.this.plan.getTypes());
                TupleDomain filterDomain = decomposedPredicate.getTupleDomain().transform(tableScanNode.getAssignments()::get);
                this.addInputTableConstraints((TupleDomain<ColumnHandle>)filterDomain, tableScanNode, context);
                return null;
            }
            return this.processChildren(node, context);
        }

        @Override
        public Void visitTableScan(TableScanNode node, IoPlan.IoPlanBuilder context) {
            this.addInputTableConstraints((TupleDomain<ColumnHandle>)TupleDomain.all(), node, context);
            return null;
        }

        @Override
        public Void visitTableFinish(TableFinishNode node, IoPlan.IoPlanBuilder context) {
            TableWriterNode.WriterTarget writerTarget = node.getTarget();
            if (writerTarget instanceof TableWriterNode.CreateTarget) {
                TableWriterNode.CreateTarget target = (TableWriterNode.CreateTarget)writerTarget;
                context.setOutputTable(new CatalogSchemaTableName(target.getHandle().getCatalogName().getCatalogName(), target.getSchemaTableName().getSchemaName(), target.getSchemaTableName().getTableName()));
            } else if (writerTarget instanceof TableWriterNode.InsertTarget) {
                TableWriterNode.InsertTarget target = (TableWriterNode.InsertTarget)writerTarget;
                context.setOutputTable(new CatalogSchemaTableName(target.getHandle().getCatalogName().getCatalogName(), target.getSchemaTableName().getSchemaName(), target.getSchemaTableName().getTableName()));
            } else if (writerTarget instanceof TableWriterNode.DeleteTarget) {
                TableWriterNode.DeleteTarget target = (TableWriterNode.DeleteTarget)writerTarget;
                context.setOutputTable(new CatalogSchemaTableName(target.getHandle().getCatalogName().getCatalogName(), target.getSchemaTableName().getSchemaName(), target.getSchemaTableName().getTableName()));
            } else if (writerTarget instanceof TableWriterNode.UpdateTarget) {
                TableWriterNode.UpdateTarget target = (TableWriterNode.UpdateTarget)writerTarget;
                context.setOutputTable(new CatalogSchemaTableName(target.getHandle().getCatalogName().getCatalogName(), target.getSchemaTableName().getSchemaName(), target.getSchemaTableName().getTableName()));
            } else if (writerTarget instanceof TableWriterNode.RefreshMaterializedViewTarget) {
                TableWriterNode.RefreshMaterializedViewTarget target = (TableWriterNode.RefreshMaterializedViewTarget)writerTarget;
                context.setOutputTable(new CatalogSchemaTableName(target.getInsertHandle().getCatalogName().getCatalogName(), target.getSchemaTableName().getSchemaName(), target.getSchemaTableName().getTableName()));
            } else {
                if (writerTarget instanceof TableWriterNode.CreateReference || writerTarget instanceof TableWriterNode.InsertReference) {
                    throw new IllegalStateException(String.format("%s should not appear in final plan", writerTarget.getClass().getSimpleName()));
                }
                throw new IllegalStateException(String.format("Unknown WriterTarget subclass %s", writerTarget.getClass().getSimpleName()));
            }
            return this.processChildren(node, context);
        }

        private void addInputTableConstraints(TupleDomain<ColumnHandle> filterDomain, TableScanNode tableScan, IoPlan.IoPlanBuilder context) {
            TableHandle table = tableScan.getTable();
            TableMetadata tableMetadata = IoPlanPrinter.this.metadata.getTableMetadata(IoPlanPrinter.this.session, table);
            TupleDomain<ColumnHandle> predicateDomain = IoPlanPrinter.this.metadata.getTableProperties(IoPlanPrinter.this.session, table).getPredicate();
            EstimatedStatsAndCost estimatedStatsAndCost = this.getEstimatedStatsAndCost(tableScan);
            context.addInputTableColumnInfo(new IoPlan.TableColumnInfo(new CatalogSchemaTableName(tableMetadata.getCatalogName().getCatalogName(), tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName()), this.parseConstraints(table, (TupleDomain<ColumnHandle>)predicateDomain.intersect(filterDomain)), estimatedStatsAndCost));
        }

        private EstimatedStatsAndCost getEstimatedStatsAndCost(TableScanNode node) {
            StatsAndCosts statsAndCosts = IoPlanPrinter.this.plan.getStatsAndCosts();
            PlanNodeStatsEstimate stats = statsAndCosts.getStats().get(node.getId());
            PlanCostEstimate cost = statsAndCosts.getCosts().get(node.getId());
            EstimatedStatsAndCost estimatedStatsAndCost = new EstimatedStatsAndCost(stats.getOutputRowCount(), stats.getOutputSizeInBytes(node.getOutputSymbols(), IoPlanPrinter.this.plan.getTypes()), cost.getCpuCost(), cost.getMaxMemory(), cost.getNetworkCost());
            return estimatedStatsAndCost;
        }

        private Set<ColumnConstraint> parseConstraints(TableHandle tableHandle, TupleDomain<ColumnHandle> constraint) {
            Preconditions.checkArgument((!constraint.isNone() ? 1 : 0) != 0);
            ImmutableSet.Builder columnConstraints = ImmutableSet.builder();
            for (Map.Entry entry : ((Map)constraint.getDomains().get()).entrySet()) {
                ColumnMetadata columnMetadata = IoPlanPrinter.this.metadata.getColumnMetadata(IoPlanPrinter.this.session, tableHandle, (ColumnHandle)entry.getKey());
                columnConstraints.add((Object)new ColumnConstraint(columnMetadata.getName(), columnMetadata.getType(), this.parseDomain(((Domain)entry.getValue()).simplify())));
            }
            return columnConstraints.build();
        }

        private FormattedDomain parseDomain(Domain domain) {
            ImmutableSet.Builder formattedRanges = ImmutableSet.builder();
            Type type = domain.getType();
            domain.getValues().getValuesProcessor().consume(ranges -> formattedRanges.addAll((Iterable)ranges.getOrderedRanges().stream().map(range -> new FormattedRange(this.formatMarker(range.getLow()), this.formatMarker(range.getHigh()))).collect(ImmutableSet.toImmutableSet())), discreteValues -> formattedRanges.addAll((Iterable)discreteValues.getValues().stream().map(value -> IoPlanPrinter.this.valuePrinter.castToVarcharOrFail(type, value)).map(value -> new FormattedMarker(Optional.of(value), Marker.Bound.EXACTLY)).map(marker -> new FormattedRange((FormattedMarker)marker, (FormattedMarker)marker)).collect(ImmutableSet.toImmutableSet())), allOrNone -> {
                throw new IllegalStateException("Unreachable AllOrNone consumer");
            });
            return new FormattedDomain(domain.isNullAllowed(), (Set<FormattedRange>)formattedRanges.build());
        }

        private FormattedMarker formatMarker(Marker marker) {
            if (marker.getValueBlock().isEmpty()) {
                return new FormattedMarker(Optional.empty(), marker.getBound());
            }
            return new FormattedMarker(Optional.of(IoPlanPrinter.this.valuePrinter.castToVarcharOrFail(marker.getType(), marker.getValue())), marker.getBound());
        }

        private Void processChildren(PlanNode node, IoPlan.IoPlanBuilder context) {
            for (PlanNode child : node.getSources()) {
                child.accept(this, context);
            }
            return null;
        }
    }

    public static class FormattedMarker {
        private final Optional<String> value;
        private final Marker.Bound bound;

        @JsonCreator
        public FormattedMarker(@JsonProperty(value="value") Optional<String> value, @JsonProperty(value="bound") Marker.Bound bound) {
            this.value = Objects.requireNonNull(value, "value is null");
            this.bound = Objects.requireNonNull(bound, "bound is null");
        }

        @JsonProperty
        public Optional<String> getValue() {
            return this.value;
        }

        @JsonProperty
        public Marker.Bound getBound() {
            return this.bound;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FormattedMarker o = (FormattedMarker)obj;
            return Objects.equals(this.value, o.value) && this.bound == o.bound;
        }

        public int hashCode() {
            return Objects.hash(this.value, this.bound);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("bound", (Object)this.bound).toString();
        }
    }

    public static class FormattedRange {
        private final FormattedMarker low;
        private final FormattedMarker high;

        @JsonCreator
        public FormattedRange(@JsonProperty(value="low") FormattedMarker low, @JsonProperty(value="high") FormattedMarker high) {
            this.low = Objects.requireNonNull(low, "low is null");
            this.high = Objects.requireNonNull(high, "high is null");
        }

        @JsonProperty
        public FormattedMarker getLow() {
            return this.low;
        }

        @JsonProperty
        public FormattedMarker getHigh() {
            return this.high;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FormattedRange o = (FormattedRange)obj;
            return Objects.equals(this.low, o.low) && Objects.equals(this.high, o.high);
        }

        public int hashCode() {
            return Objects.hash(this.low, this.high);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("low", (Object)this.low).add("high", (Object)this.high).toString();
        }
    }

    public static class FormattedDomain {
        private final boolean nullsAllowed;
        private final Set<FormattedRange> ranges;

        @JsonCreator
        public FormattedDomain(@JsonProperty(value="nullsAllowed") boolean nullsAllowed, @JsonProperty(value="ranges") Set<FormattedRange> ranges) {
            this.nullsAllowed = nullsAllowed;
            this.ranges = ImmutableSet.copyOf((Collection)Objects.requireNonNull(ranges, "ranges is null"));
        }

        @JsonProperty
        public boolean isNullsAllowed() {
            return this.nullsAllowed;
        }

        @JsonProperty
        public Set<FormattedRange> getRanges() {
            return this.ranges;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FormattedDomain o = (FormattedDomain)obj;
            return Objects.equals(this.nullsAllowed, o.nullsAllowed) && Objects.equals(this.ranges, o.ranges);
        }

        public int hashCode() {
            return Objects.hash(this.nullsAllowed, this.ranges);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("nullsAllowed", this.nullsAllowed).add("ranges", this.ranges).toString();
        }
    }

    public static class EstimatedStatsAndCost {
        private final double outputRowCount;
        private final double outputSizeInBytes;
        private final double cpuCost;
        private final double maxMemory;
        private final double networkCost;

        @JsonCreator
        public EstimatedStatsAndCost(@JsonProperty(value="outputRowCount") double outputRowCount, @JsonProperty(value="outputSizeInBytes") double outputSizeInBytes, @JsonProperty(value="cpuCost") double cpuCost, @JsonProperty(value="maxMemory") double maxMemory, @JsonProperty(value="networkCost") double networkCost) {
            this.outputRowCount = Objects.requireNonNull(Double.valueOf(outputRowCount), "outputRowCount is null");
            this.outputSizeInBytes = Objects.requireNonNull(Double.valueOf(outputSizeInBytes), "outputSizeInBytes is null");
            this.cpuCost = Objects.requireNonNull(Double.valueOf(cpuCost), "cpuCost is null");
            this.maxMemory = Objects.requireNonNull(Double.valueOf(maxMemory), "maxMemory is null");
            this.networkCost = Objects.requireNonNull(Double.valueOf(networkCost), "networkCost is null");
        }

        @JsonProperty
        public double getOutputRowCount() {
            return this.outputRowCount;
        }

        @JsonProperty
        public double getOutputSizeInBytes() {
            return this.outputSizeInBytes;
        }

        @JsonProperty
        public double getCpuCost() {
            return this.cpuCost;
        }

        @JsonProperty
        public double getMaxMemory() {
            return this.maxMemory;
        }

        @JsonProperty
        public double getNetworkCost() {
            return this.networkCost;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EstimatedStatsAndCost o = (EstimatedStatsAndCost)obj;
            return Objects.equals(this.outputRowCount, o.outputRowCount) && Objects.equals(this.outputSizeInBytes, o.outputSizeInBytes) && Objects.equals(this.cpuCost, o.cpuCost) && Objects.equals(this.maxMemory, o.maxMemory) && Objects.equals(this.networkCost, o.networkCost);
        }

        public int hashCode() {
            return Objects.hash(this.outputRowCount, this.outputSizeInBytes, this.cpuCost, this.maxMemory, this.networkCost);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("outputRowCount", this.outputRowCount).add("outputSizeInBytes", this.outputSizeInBytes).add("cpuCost", this.cpuCost).add("maxMemory", this.maxMemory).add("networkCost", this.networkCost).toString();
        }
    }

    public static class ColumnConstraint {
        private final String columnName;
        private final Type type;
        private final FormattedDomain domain;

        @JsonCreator
        public ColumnConstraint(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="type") Type type, @JsonProperty(value="domain") FormattedDomain domain) {
            this.columnName = Objects.requireNonNull(columnName, "columnName is null");
            this.type = Objects.requireNonNull(type, "type is null");
            this.domain = Objects.requireNonNull(domain, "domain is null");
        }

        @JsonProperty
        public String getColumnName() {
            return this.columnName;
        }

        @JsonProperty
        public Type getType() {
            return this.type;
        }

        @JsonProperty
        public FormattedDomain getDomain() {
            return this.domain;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ColumnConstraint o = (ColumnConstraint)obj;
            return Objects.equals(this.columnName, o.columnName) && Objects.equals(this.type, o.type) && Objects.equals(this.domain, o.domain);
        }

        public int hashCode() {
            return Objects.hash(this.columnName, this.type, this.domain);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("columnName", (Object)this.columnName).add("typeSignature", (Object)this.type).add("domain", (Object)this.domain).toString();
        }
    }

    public static class IoPlan {
        private final Set<TableColumnInfo> inputTableColumnInfos;
        private final Optional<CatalogSchemaTableName> outputTable;
        private final EstimatedStatsAndCost estimate;

        @JsonCreator
        public IoPlan(@JsonProperty(value="inputTableColumnInfos") Set<TableColumnInfo> inputTableColumnInfos, @JsonProperty(value="outputTable") Optional<CatalogSchemaTableName> outputTable, @JsonProperty(value="estimate") EstimatedStatsAndCost estimate) {
            this.inputTableColumnInfos = ImmutableSet.copyOf((Collection)Objects.requireNonNull(inputTableColumnInfos, "inputTableColumnInfos is null"));
            this.outputTable = Objects.requireNonNull(outputTable, "outputTable is null");
            this.estimate = Objects.requireNonNull(estimate, "estimate is null");
        }

        @JsonProperty
        public Set<TableColumnInfo> getInputTableColumnInfos() {
            return this.inputTableColumnInfos;
        }

        @JsonProperty
        public Optional<CatalogSchemaTableName> getOutputTable() {
            return this.outputTable;
        }

        @JsonProperty
        public EstimatedStatsAndCost getEstimate() {
            return this.estimate;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            IoPlan o = (IoPlan)obj;
            return Objects.equals(this.inputTableColumnInfos, o.inputTableColumnInfos) && Objects.equals(this.outputTable, o.outputTable);
        }

        public int hashCode() {
            return Objects.hash(this.inputTableColumnInfos, this.outputTable);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("inputTableColumnInfos", this.inputTableColumnInfos).add("outputTable", this.outputTable).add("estimate", (Object)this.estimate).toString();
        }

        public static class TableColumnInfo {
            private final CatalogSchemaTableName table;
            private final Set<ColumnConstraint> columnConstraints;
            private final EstimatedStatsAndCost estimate;

            @JsonCreator
            public TableColumnInfo(@JsonProperty(value="table") CatalogSchemaTableName table, @JsonProperty(value="columnConstraints") Set<ColumnConstraint> columnConstraints, @JsonProperty(value="estimate") EstimatedStatsAndCost estimate) {
                this.table = Objects.requireNonNull(table, "table is null");
                this.columnConstraints = Objects.requireNonNull(columnConstraints, "columnConstraints is null");
                this.estimate = Objects.requireNonNull(estimate, "estimate is null");
            }

            @JsonProperty
            public CatalogSchemaTableName getTable() {
                return this.table;
            }

            @JsonProperty
            public Set<ColumnConstraint> getColumnConstraints() {
                return this.columnConstraints;
            }

            @JsonProperty
            public EstimatedStatsAndCost getEstimate() {
                return this.estimate;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                TableColumnInfo o = (TableColumnInfo)obj;
                return Objects.equals(this.table, o.table) && Objects.equals(this.columnConstraints, o.columnConstraints) && Objects.equals(this.estimate, o.estimate);
            }

            public int hashCode() {
                return Objects.hash(this.table, this.columnConstraints, this.estimate);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("columnConstraints", this.columnConstraints).add("estimate", (Object)this.estimate).toString();
            }
        }

        protected static class IoPlanBuilder {
            private final Plan plan;
            private final Set<TableColumnInfo> inputTableColumnInfos;
            private Optional<CatalogSchemaTableName> outputTable;

            private IoPlanBuilder(Plan plan) {
                this.plan = plan;
                this.inputTableColumnInfos = new HashSet<TableColumnInfo>();
                this.outputTable = Optional.empty();
            }

            private IoPlanBuilder addInputTableColumnInfo(TableColumnInfo tableColumnInfo) {
                this.inputTableColumnInfos.add(tableColumnInfo);
                return this;
            }

            private IoPlanBuilder setOutputTable(CatalogSchemaTableName outputTable) {
                this.outputTable = Optional.of(outputTable);
                return this;
            }

            private IoPlan build() {
                return new IoPlan(this.inputTableColumnInfos, this.outputTable, this.getEstimatedStatsAndCost());
            }

            private EstimatedStatsAndCost getEstimatedStatsAndCost() {
                PlanNode root = this.plan.getRoot();
                StatsAndCosts statsAndCosts = this.plan.getStatsAndCosts();
                PlanNodeStatsEstimate statsEstimate = statsAndCosts.getStats().get(root.getId());
                PlanCostEstimate costEstimate = statsAndCosts.getCosts().get(root.getId());
                return new EstimatedStatsAndCost(statsEstimate.getOutputRowCount(), statsEstimate.getOutputSizeInBytes(root.getOutputSymbols(), this.plan.getTypes()), costEstimate.getCpuCost(), costEstimate.getMaxMemory(), costEstimate.getNetworkCost());
            }
        }
    }
}

