/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.relational;

import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.TrinoException;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.ConstantExpression;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.LambdaDefinitionExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.RowExpressionVisitor;
import io.trino.sql.relational.SpecialForm;
import io.trino.sql.relational.VariableReferenceExpression;
import java.util.Objects;

public class DeterminismEvaluator {
    private final Metadata metadata;

    public DeterminismEvaluator(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public boolean isDeterministic(RowExpression expression) {
        return expression.accept(new Visitor(this.metadata), null);
    }

    private static class Visitor
    implements RowExpressionVisitor<Boolean, Void> {
        private final Metadata metadata;

        public Visitor(Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public Boolean visitInputReference(InputReferenceExpression reference, Void context) {
            return true;
        }

        @Override
        public Boolean visitConstant(ConstantExpression literal, Void context) {
            return true;
        }

        @Override
        public Boolean visitCall(CallExpression call, Void context) {
            ResolvedFunction resolvedFunction = call.getResolvedFunction();
            if (!this.isDeterministic(resolvedFunction)) {
                return false;
            }
            return call.getArguments().stream().allMatch(expression -> expression.accept(this, context));
        }

        private boolean isDeterministic(ResolvedFunction resolvedFunction) {
            try {
                return this.metadata.getFunctionMetadata(resolvedFunction).isDeterministic();
            }
            catch (TrinoException ignored) {
                return true;
            }
        }

        @Override
        public Boolean visitSpecialForm(SpecialForm specialForm, Void context) {
            return specialForm.getArguments().stream().allMatch(expression -> expression.accept(this, context));
        }

        @Override
        public Boolean visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return lambda.getBody().accept(this, context);
        }

        @Override
        public Boolean visitVariableReference(VariableReferenceExpression reference, Void context) {
            return true;
        }
    }
}

