/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.connector.system.StaticSystemTablesProvider;
import io.trino.connector.system.SystemTablesMetadata;
import io.trino.execution.QueryIdGenerator;
import io.trino.metadata.Catalog;
import io.trino.metadata.SessionPropertyManager;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.security.Identity;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.spi.type.TimeZoneKey;
import io.trino.sql.SqlPath;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public final class TestingSession {
    public static final String TESTING_CATALOG = "testing_catalog";
    private static final QueryIdGenerator queryIdGenerator = new QueryIdGenerator();
    public static final TimeZoneKey DEFAULT_TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKey((String)"Pacific/Apia");

    private TestingSession() {
    }

    public static Session.SessionBuilder testSessionBuilder() {
        return TestingSession.testSessionBuilder(new SessionPropertyManager());
    }

    public static Session.SessionBuilder testSessionBuilder(SessionPropertyManager sessionPropertyManager) {
        return Session.builder(sessionPropertyManager).setQueryId(queryIdGenerator.createNextQueryId()).setIdentity(Identity.ofUser((String)"user")).setSource("test").setCatalog("catalog").setSchema("schema").setPath(new SqlPath(Optional.of("path"))).setTimeZoneKey(DEFAULT_TIME_ZONE_KEY).setLocale(Locale.ENGLISH).setSystemProperty("ignore_stats_calculator_failures", "false").setRemoteUserAddress("address").setUserAgent("agent");
    }

    public static Catalog createBogusTestingCatalog(String catalogName) {
        CatalogName catalog = new CatalogName(catalogName);
        return new Catalog(catalogName, catalog, TestingSession.createTestSessionConnector(), CatalogName.createInformationSchemaCatalogName(catalog), TestingSession.createTestSessionConnector(), CatalogName.createSystemTablesCatalogName(catalog), TestingSession.createTestSessionConnector());
    }

    private static Connector createTestSessionConnector() {
        return new Connector(){

            public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
                return new ConnectorTransactionHandle(){};
            }

            public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
                return new SystemTablesMetadata(new StaticSystemTablesProvider((Set<SystemTable>)ImmutableSet.of()));
            }
        };
    }
}

