/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import io.airlift.bytecode.BytecodeUtils;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.ClassGenerator;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.log.Logger;
import java.lang.invoke.MethodHandle;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;

public final class CompilerUtils {
    private static final Logger log = Logger.get(CompilerUtils.class);
    private static final AtomicLong CLASS_ID = new AtomicLong();
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("YYYYMMdd_HHmmss");

    private CompilerUtils() {
    }

    public static ParameterizedType makeClassName(String baseName, Optional<String> suffix) {
        String className = baseName + "_" + suffix.orElseGet(() -> Instant.now().atZone(ZoneOffset.UTC).format(TIMESTAMP_FORMAT)) + "_" + CLASS_ID.incrementAndGet();
        return ParameterizedType.typeFromJavaClassName((String)("io.trino.$gen." + BytecodeUtils.toJavaIdentifierString((String)className)));
    }

    public static ParameterizedType makeClassName(String baseName) {
        return CompilerUtils.makeClassName(baseName, Optional.empty());
    }

    public static <T> Class<? extends T> defineClass(ClassDefinition classDefinition, Class<T> superType, Map<Long, MethodHandle> callSiteBindings, ClassLoader parentClassLoader) {
        return CompilerUtils.defineClass(classDefinition, superType, new DynamicClassLoader(parentClassLoader, callSiteBindings));
    }

    public static <T> Class<? extends T> defineClass(ClassDefinition classDefinition, Class<T> superType, DynamicClassLoader classLoader) {
        log.debug("Defining class: %s", new Object[]{classDefinition.getName()});
        return ClassGenerator.classGenerator((DynamicClassLoader)classLoader).defineClass(classDefinition, superType);
    }
}

