/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.trino.cost.AggregationStatsRule;
import io.trino.cost.AssignUniqueIdStatsRule;
import io.trino.cost.ComposableStatsCalculator;
import io.trino.cost.EnforceSingleRowStatsRule;
import io.trino.cost.ExchangeStatsRule;
import io.trino.cost.FilterStatsCalculator;
import io.trino.cost.FilterStatsRule;
import io.trino.cost.JoinStatsRule;
import io.trino.cost.LimitStatsRule;
import io.trino.cost.OutputStatsRule;
import io.trino.cost.ProjectStatsRule;
import io.trino.cost.RowNumberStatsRule;
import io.trino.cost.ScalarStatsCalculator;
import io.trino.cost.SemiJoinStatsRule;
import io.trino.cost.SimpleFilterProjectSemiJoinStatsRule;
import io.trino.cost.SortStatsRule;
import io.trino.cost.SpatialJoinStatsRule;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsNormalizer;
import io.trino.cost.TableScanStatsRule;
import io.trino.cost.TopNStatsRule;
import io.trino.cost.UnionStatsRule;
import io.trino.cost.ValuesStatsRule;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.TypeAnalyzer;
import java.util.List;
import javax.inject.Singleton;

public class StatsCalculatorModule
implements Module {
    public void configure(Binder binder) {
    }

    @Provides
    @Singleton
    public static StatsCalculator createNewStatsCalculator(Metadata metadata, TypeAnalyzer typeAnalyzer) {
        StatsNormalizer normalizer = new StatsNormalizer();
        ScalarStatsCalculator scalarStatsCalculator = new ScalarStatsCalculator(metadata, typeAnalyzer);
        FilterStatsCalculator filterStatsCalculator = new FilterStatsCalculator(metadata, scalarStatsCalculator, normalizer);
        ImmutableList.Builder rules = ImmutableList.builder();
        rules.add((Object)new OutputStatsRule());
        rules.add((Object)new TableScanStatsRule(metadata, normalizer));
        rules.add((Object)new SimpleFilterProjectSemiJoinStatsRule(metadata, normalizer, filterStatsCalculator));
        rules.add((Object)new FilterStatsRule(normalizer, filterStatsCalculator));
        rules.add((Object)new ValuesStatsRule(metadata));
        rules.add((Object)new LimitStatsRule(normalizer));
        rules.add((Object)new TopNStatsRule(normalizer));
        rules.add((Object)new EnforceSingleRowStatsRule(normalizer));
        rules.add((Object)new ProjectStatsRule(scalarStatsCalculator, normalizer));
        rules.add((Object)new ExchangeStatsRule(normalizer));
        rules.add((Object)new JoinStatsRule(filterStatsCalculator, normalizer));
        rules.add((Object)new SpatialJoinStatsRule(filterStatsCalculator, normalizer));
        rules.add((Object)new AggregationStatsRule(normalizer));
        rules.add((Object)new UnionStatsRule(normalizer));
        rules.add((Object)new AssignUniqueIdStatsRule());
        rules.add((Object)new SemiJoinStatsRule());
        rules.add((Object)new RowNumberStatsRule(normalizer));
        rules.add((Object)new SortStatsRule());
        return new ComposableStatsCalculator((List<ComposableStatsCalculator.Rule<?>>)rules.build());
    }
}

