/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.sql.NodeUtils;
import io.trino.sql.ParameterUtils;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.tree.AddColumn;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.Statement;
import io.trino.transaction.TransactionManager;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class AddColumnTask
implements DataDefinitionTask<AddColumn> {
    @Override
    public String getName() {
        return "ADD COLUMN";
    }

    @Override
    public ListenableFuture<?> execute(AddColumn statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Type type;
        QualifiedObjectName tableName;
        Session session = stateMachine.getSession();
        Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName()));
        if (tableHandle.isEmpty()) {
            if (!statement.isTableExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", tableName);
            }
            return Futures.immediateFuture(null);
        }
        CatalogName catalogName = metadata.getCatalogHandle(session, tableName.getCatalogName()).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + tableName.getCatalogName()));
        accessControl.checkCanAddColumns(session.toSecurityContext(), tableName);
        Map<String, ColumnHandle> columnHandles = metadata.getColumnHandles(session, tableHandle.get());
        ColumnDefinition element = statement.getColumn();
        try {
            type = metadata.getType(TypeSignatureTranslator.toTypeSignature(element.getType()));
        }
        catch (TypeNotFoundException e) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_NOT_FOUND, (Node)element, "Unknown type '%s' for column '%s'", element.getType(), element.getName());
        }
        if (type.equals((Object)UnknownType.UNKNOWN)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_TYPE_UNKNOWN, (Node)element, "Unknown type '%s' for column '%s'", element.getType(), element.getName());
        }
        if (columnHandles.containsKey(element.getName().getValue().toLowerCase(Locale.ENGLISH))) {
            if (!statement.isColumnNotExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_ALREADY_EXISTS, (Node)statement, "Column '%s' already exists", element.getName());
            }
            return Futures.immediateFuture(null);
        }
        if (!element.isNullable() && !metadata.getConnectorCapabilities(session, catalogName).contains(ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)element, "Catalog '%s' does not support NOT NULL for column '%s'", catalogName.getCatalogName(), element.getName());
        }
        Map<String, Expression> sqlProperties = NodeUtils.mapFromProperties(element.getProperties());
        Map<String, Object> columnProperties = metadata.getColumnPropertyManager().getProperties(catalogName, tableName.getCatalogName(), sqlProperties, session, metadata, accessControl, ParameterUtils.parameterExtractor((Statement)statement, parameters));
        ColumnMetadata column = ColumnMetadata.builder().setName(element.getName().getValue()).setType(type).setNullable(element.isNullable()).setComment(element.getComment()).setProperties(columnProperties).build();
        metadata.addColumn(session, tableHandle.get(), column);
        return Futures.immediateFuture(null);
    }
}

